/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.angermod.events;

import com.github.namikon.angermod.AngerMod;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import eu.usrv.yamcore.auxiliary.EntityHelper;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;

public class EatCookedAnimalsEvent {
    @SubscribeEvent
    public void onPlayerUsesItem(PlayerUseItemEvent.Start pEvent) {
        try {
            EntityPlayer tEP = pEvent.entityPlayer;
            if (tEP == null) {
                return;
            }
            String tUsedItemName = pEvent.item.func_77977_a();
            AngerMod.Logger.debug((Object)String.format("Using item %s", tUsedItemName));
            this.TryTriggerAnimals(AngerMod._cfgManager.PigFoodTrigger, tUsedItemName, tEP, EntityPig.class);
            this.TryTriggerAnimals(AngerMod._cfgManager.CowFoodTrigger, tUsedItemName, tEP, EntityCow.class);
            this.TryTriggerAnimals(AngerMod._cfgManager.ChickenFoodTrigger, tUsedItemName, tEP, EntityChicken.class);
            this.TryTriggerAnimals(AngerMod._cfgManager.SheepFoodTrigger, tUsedItemName, tEP, EntitySheep.class);
        }
        catch (Exception e) {
            AngerMod.Logger.warn("EatCookedAnimalsEvent.onPlayerUsesItem.Error", (Object)"An error occoured while processing onPlayerUsesItem. Please report");
            AngerMod.Logger.DumpStack("EatCookedAnimalsEvent.onPlayerUsesItem.Stack", e);
        }
    }

    private void TryTriggerAnimals(String[] pKeywordList, String pUsedItem, EntityPlayer pEP, Class pMobClassToTrigger) {
        int tRange = AngerMod._cfgManager.FriendlyMobRevengeRadius;
        try {
            for (String s : pKeywordList) {
                if (!pUsedItem.contains(s)) continue;
                EntityHelper.DealDamageToEntitiesInRange((EntityPlayer)pEP, (int)tRange, (Class)pMobClassToTrigger, (int)0);
            }
        }
        catch (Exception e) {
            AngerMod.Logger.warn("EatCookedAnimalsEvent.TryTriggerAnimals.Error", (Object)"An error occoured while processing TriggerAnimals. Please report");
            AngerMod.Logger.DumpStack("EatCookedAnimalsEvent.TryTriggerAnimals.Stack", e);
        }
    }
}

