/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class CollectionUtils {
    public static <T> boolean contains(T[] array, T object) {
        for (T t : array) {
            if (!t.equals(object)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(Iterable<T> list, T object) {
        for (T t : list) {
            if (!t.equals(object)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean allMatch(Iterable<T> iterable, Predicate<T> predicate) {
        for (T obj : iterable) {
            if (predicate.test(obj)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(Iterable<T> iterable, Predicate<T> predicate) {
        for (T obj : iterable) {
            if (!predicate.test(obj)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean noneMatch(Iterable<T> iterable, Predicate<T> predicate) {
        for (T obj : iterable) {
            if (!predicate.test(obj)) continue;
            return false;
        }
        return true;
    }

    public static <T, R> List<R> mapArrayToList(T[] source, Function<T, R> mapper) {
        ArrayList<R> list = new ArrayList<R>(source.length);
        for (T t : source) {
            list.add(mapper.apply(t));
        }
        return list;
    }

    public static <T, R> R[] mapArray(T[] source, Function<Integer, R[]> mappedArrFactory, Function<T, R> mapper) {
        R[] mapped = mappedArrFactory.apply(source.length);
        if (mapped.length != source.length) {
            throw new IllegalArgumentException("Mapped array should have the same length (" + source.length + ") as source array. Provided length:" + mapped.length);
        }
        for (int i = 0; i < source.length; ++i) {
            mapped[i] = mapper.apply(source[i]);
        }
        return mapped;
    }
}

