/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.utils;

import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.MoveGen;
import java.util.List;
import java.util.concurrent.Callable;

class PerftCallable
implements Callable<Long> {
    private Board board;
    private int depth;

    public PerftCallable(Board board, int depth) {
        this.board = board;
        this.depth = depth;
    }

    private long perft(int myDepth) {
        if (myDepth <= 0) {
            return 1L;
        }
        List<Move> moves = MoveGen.genLegalMoves(this.board);
        long n = 0L;
        for (Move m : moves) {
            this.board.applyMove(m);
            n += this.perft(myDepth - 1);
            this.board.undoLastMove();
        }
        return n;
    }

    @Override
    public Long call() throws Exception {
        return this.perft(this.depth);
    }
}

