/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.GTHandler;

import gregtech.api.interfaces.IItemContainer;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum CropItemList implements IItemContainer
{
    weedingTrowel,
    Spade,
    cropGeneExtractorLV,
    cropGeneExtractorMV,
    cropGeneExtractorHV,
    cropGeneExtractorEV,
    cropGeneExtractorIV,
    cropGeneExtractorLuV,
    cropGeneExtractorZPM,
    cropGeneExtractorUV,
    cropGeneExtractorUHV,
    cropReplicatorLV,
    cropReplicatorMV,
    cropReplicatorHV,
    cropReplicatorEV,
    cropReplicatorIV,
    cropReplicatorLuV,
    cropReplicatorZPM,
    cropReplicatorUV,
    cropReplicatorUHV,
    cropSynthesiserLV,
    cropSynthesiserMV,
    cropSynthesiserHV,
    cropSynthesiserEV,
    cropSynthesiserIV,
    cropSynthesiserLuV,
    cropSynthesiserZPM,
    cropSynthesiserUV,
    cropSynthesiserUHV,
    cropWeedPicker;

    private ItemStack mStack;
    private boolean mHasNotBeenSet = true;

    public IItemContainer set(Item aItem) {
        this.mHasNotBeenSet = false;
        if (aItem == null) {
            return this;
        }
        ItemStack aStack = new ItemStack(aItem, 1, 0);
        this.mStack = GTUtility.copyAmount((int)1, (ItemStack)aStack);
        return this;
    }

    public IItemContainer set(ItemStack aStack) {
        this.mHasNotBeenSet = false;
        this.mStack = GTUtility.copyAmount((int)1, (ItemStack)aStack);
        return this;
    }

    public Item getItem() {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid((ItemStack)this.mStack)) {
            return null;
        }
        return this.mStack.func_77973_b();
    }

    public Block getBlock() {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        return GTUtility.getBlockFromItem((Item)this.getItem());
    }

    public final boolean hasBeenSet() {
        return !this.mHasNotBeenSet;
    }

    public boolean isStackEqual(Object aStack) {
        return this.isStackEqual(aStack, false, false);
    }

    public boolean isStackEqual(Object aStack, boolean aWildcard, boolean aIgnoreNBT) {
        return !GTUtility.isStackInvalid((Object)aStack) && GTUtility.areUnificationsEqual((ItemStack)((ItemStack)aStack), (ItemStack)(aWildcard ? this.getWildcard(1L, new Object[0]) : this.get(1L, new Object[0])), (boolean)aIgnoreNBT);
    }

    public ItemStack get(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid((ItemStack)this.mStack)) {
            return GTUtility.copyAmount((long)aAmount, (Object[])aReplacements);
        }
        return GTUtility.copyAmount((long)aAmount, (ItemStack)GTOreDictUnificator.get((ItemStack)this.mStack));
    }

    public ItemStack getWildcard(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid((ItemStack)this.mStack)) {
            return GTUtility.copyAmount((long)aAmount, (Object[])aReplacements);
        }
        return GTUtility.copyAmountAndMetaData((long)aAmount, (long)32767L, (ItemStack)GTOreDictUnificator.get((ItemStack)this.mStack));
    }

    public ItemStack getUndamaged(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid((ItemStack)this.mStack)) {
            return GTUtility.copyAmount((long)aAmount, (Object[])aReplacements);
        }
        return GTUtility.copyAmountAndMetaData((long)aAmount, (long)0L, (ItemStack)GTOreDictUnificator.get((ItemStack)this.mStack));
    }

    public ItemStack getAlmostBroken(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid((ItemStack)this.mStack)) {
            return GTUtility.copyAmount((long)aAmount, (Object[])aReplacements);
        }
        return GTUtility.copyAmountAndMetaData((long)aAmount, (long)(this.mStack.func_77958_k() - 1), (ItemStack)GTOreDictUnificator.get((ItemStack)this.mStack));
    }

    public ItemStack getWithName(long aAmount, String aDisplayName, Object ... aReplacements) {
        ItemStack rStack = this.get(1L, aReplacements);
        if (GTUtility.isStackInvalid((ItemStack)rStack)) {
            return null;
        }
        rStack.func_151001_c(aDisplayName);
        return GTUtility.copyAmount((long)aAmount, (ItemStack)rStack);
    }

    public ItemStack getWithCharge(long aAmount, int aEnergy, Object ... aReplacements) {
        ItemStack rStack = this.get(1L, aReplacements);
        if (GTUtility.isStackInvalid((ItemStack)rStack)) {
            return null;
        }
        GTModHandler.chargeElectricItem((ItemStack)rStack, (int)aEnergy, (int)Integer.MAX_VALUE, (boolean)true, (boolean)false);
        return GTUtility.copyAmount((long)aAmount, (ItemStack)rStack);
    }

    public ItemStack getWithDamage(long aAmount, long aMetaValue, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GTUtility.isStackInvalid((ItemStack)this.mStack)) {
            return GTUtility.copyAmount((long)aAmount, (Object[])aReplacements);
        }
        return GTUtility.copyAmountAndMetaData((long)aAmount, (long)aMetaValue, (ItemStack)GTOreDictUnificator.get((ItemStack)this.mStack));
    }

    public IItemContainer registerOre(Object ... aOreNames) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        for (Object tOreName : aOreNames) {
            GTOreDictUnificator.registerOre((Object)tOreName, (ItemStack)this.get(1L, new Object[0]));
        }
        return this;
    }

    public IItemContainer registerWildcardAsOre(Object ... aOreNames) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        for (Object tOreName : aOreNames) {
            GTOreDictUnificator.registerOre((Object)tOreName, (ItemStack)this.getWildcard(1L, new Object[0]));
        }
        return this;
    }
}

