/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.api.infusionrecipe;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.glease.tc4tweak.api.infusionrecipe.RecipeIngredientOr;
import net.glease.tc4tweak.api.infusionrecipe.Utility;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public interface RecipeIngredient {
    public static final RecipeIngredient ERROR = new RecipeIngredient(){

        @Override
        public List<ItemStack> getRepresentativeStacks() {
            ItemStack error = new ItemStack((Block)Blocks.field_150480_ab);
            error.func_151001_c(EnumChatFormatting.RED + "ERROR NULL INGREDIENT");
            return Collections.singletonList(error);
        }

        @Override
        public boolean matches(ItemStack stack) {
            return false;
        }
    };

    public List<ItemStack> getRepresentativeStacks();

    default public ItemStack getRepresentativeStack() {
        List<ItemStack> stacks = this.getRepresentativeStacks();
        return stacks.get(0);
    }

    public boolean matches(ItemStack var1);

    default public RecipeIngredient or(RecipeIngredient or) {
        return new RecipeIngredientOr(this, or);
    }

    public static RecipeIngredient oredict(final String name) {
        return new RecipeIngredient(){
            private int oreID = -1;

            @Override
            public List<ItemStack> getRepresentativeStacks() {
                return OreDictionary.getOres((String)name, (boolean)false);
            }

            @Override
            public boolean matches(ItemStack stack) {
                if (this.oreID == -1) {
                    this.oreID = OreDictionary.getOreID((String)name);
                }
                return ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)stack), (int)this.oreID);
            }
        };
    }

    public static RecipeIngredient oredictStrict(final String name) {
        return new RecipeIngredient(){
            private int oreID = -1;

            @Override
            public List<ItemStack> getRepresentativeStacks() {
                return OreDictionary.getOres((String)name, (boolean)false);
            }

            @Override
            public boolean matches(ItemStack stack) {
                int[] oreIDs;
                if (this.oreID == -1) {
                    this.oreID = OreDictionary.getOreID((String)name);
                }
                return (oreIDs = OreDictionary.getOreIDs((ItemStack)stack)).length == 1 && oreIDs[0] == this.oreID;
            }
        };
    }

    public static RecipeIngredient item(final boolean checkNBTTags, final ItemStack target) {
        return new RecipeIngredient(){

            @Override
            public List<ItemStack> getRepresentativeStacks() {
                return Collections.singletonList(target);
            }

            @Override
            public boolean matches(ItemStack stack) {
                return Utility.itemMatches(target, stack, checkNBTTags);
            }
        };
    }

    public static RecipeIngredient items(final boolean checkNBTTags, final ItemStack ... targets) {
        return new RecipeIngredient(){

            @Override
            public List<ItemStack> getRepresentativeStacks() {
                return Arrays.asList(targets);
            }

            @Override
            public boolean matches(ItemStack stack) {
                for (ItemStack target : targets) {
                    if (!Utility.itemMatches(target, stack, checkNBTTags)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

