/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.glease.tc4tweak.TC4Tweak;
import net.minecraftforge.common.config.Configuration;

enum ConfigurationVersion {
    LEGACY(null){

        @Override
        protected void step(Configuration c) {
            throw new IllegalStateException();
        }
    }
    ,
    V1{
        private final String[] propsToClient = new String[]{"inverted", "updateInterval", "addTooltip", "browserScale", "limitBookSearchToCategory", "limitOversizedNodeRender"};

        @Override
        protected void step(Configuration c) {
            for (String name : this.propsToClient) {
                c.moveProperty("general", name, "client");
            }
        }
    }
    ,
    V2{
        private final Map<String, String> propsToMove = ImmutableMap.of((Object)"browserScale", (Object)"scale", (Object)"inferBrowserScale", (Object)"infer", (Object)"inferBrowserScaleConsiderSearch", (Object)"considerSearchArea", (Object)"inferBrowserScaleLowerBound", (Object)"minimum", (Object)"inferBrowserScaleUpperBound", (Object)"maximum");

        @Override
        protected void step(Configuration c) {
            for (Map.Entry<String, String> name : this.propsToMove.entrySet()) {
                c.moveProperty("client", name.getKey(), "client.browser_scale");
                c.renameProperty("client.browser_scale", name.getKey(), name.getValue());
            }
        }
    }
    ,
    V3{

        @Override
        protected void step(Configuration c) {
            c.moveProperty("general", "infusionOreDictMode", "general.infusion_recipes");
            c.renameProperty("general.infusion_recipes", "infusionOreDictMode", "oreDictMode");
        }
    };

    private static final ConfigurationVersion[] VALUES;
    private final String versionMarker;

    private ConfigurationVersion() {
        this.versionMarker = this.name();
    }

    private ConfigurationVersion(String versionMarker) {
        this.versionMarker = versionMarker;
    }

    public static void migrateToLatest(Configuration c) {
        for (int i = ConfigurationVersion.identify(c).ordinal() + 1; i < VALUES.length; ++i) {
            TC4Tweak.log.info("Migrating config to {}", new Object[]{VALUES[i].getVersionMarker()});
            VALUES[i].step(c);
        }
    }

    public static ConfigurationVersion latest() {
        return VALUES[VALUES.length - 1];
    }

    public static ConfigurationVersion identify(Configuration c) {
        return Arrays.stream(VALUES).filter(v -> Objects.equals(c.getLoadedConfigVersion(), v.getVersionMarker())).findFirst().orElse(LEGACY);
    }

    @Nullable
    public String getVersionMarker() {
        return this.versionMarker;
    }

    protected abstract void step(Configuration var1);

    static {
        VALUES = ConfigurationVersion.values();
    }
}

