/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.inventory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;

public abstract class MappedItemsWithGroupedCounts<T> {
    public String nbtKey;
    protected Map<HashableItemWithoutSize, Map<T, Integer>> map;

    public MappedItemsWithGroupedCounts(String key) {
        this.nbtKey = key;
        this.map = new LinkedHashMap<HashableItemWithoutSize, Map<T, Integer>>();
    }

    public MappedItemsWithGroupedCounts(MappedItemsWithGroupedCounts copySource) {
        this.nbtKey = copySource.nbtKey;
        this.map = new HashMap<HashableItemWithoutSize, Map<T, Integer>>(copySource.map);
    }

    public void add(T group, ItemStack stack) {
        Map<T, Integer> submap;
        Integer c = (submap = this.getSubmap(stack, true)).get(group);
        submap.put(group, (c == null ? 0 : c) + stack.field_77994_a);
    }

    public int subtract(T group, HashableItemWithoutSize item, int amount) {
        Integer c;
        int numRemoved = 0;
        Map<T, Integer> submap = this.map.get(item);
        if (submap != null && (c = submap.get(group)) != null) {
            int newC = c - amount;
            if (newC > 0) {
                submap.put(group, newC);
                numRemoved = amount;
            } else {
                submap.remove(group);
                if (submap.isEmpty()) {
                    this.map.remove(item);
                }
                numRemoved = c;
            }
        }
        return numRemoved;
    }

    public int subtract(T group, ItemStack stack) {
        return this.subtract(group, new HashableItemWithoutSize(stack), stack.field_77994_a);
    }

    public void subtractFromAnyGroup(ItemStack stack) {
        HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
        Map<T, Integer> submap = this.map.get(item);
        if (submap != null) {
            T group;
            Iterator<Map.Entry<T, Integer>> iter = submap.entrySet().iterator();
            for (int toRemove = stack.field_77994_a; toRemove > 0 && iter.hasNext(); toRemove -= this.subtract(group, item, toRemove)) {
                Map.Entry<T, Integer> entry = iter.next();
                group = entry.getKey();
            }
        }
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public void removeGroup(T group) {
        if (this.map.containsKey(group)) {
            this.map.remove(group);
        }
    }

    public Iterator<Map.Entry<HashableItemWithoutSize, Map<T, Integer>>> getIterator() {
        return this.map.entrySet().iterator();
    }

    public boolean containsKey(HashableItemWithoutSize item) {
        return this.map.containsKey(item);
    }

    public int get(T group, HashableItemWithoutSize item) {
        Map<T, Integer> submap = this.map.get(item);
        if (submap == null) {
            return 0;
        }
        Integer c = submap.get(group);
        return c == null ? 0 : c;
    }

    public Map<T, Integer> getGroupsForItem(HashableItemWithoutSize item) {
        return this.map.get(item);
    }

    public void set(T group, ItemStack stack) {
        if (stack.field_77994_a > 0) {
            Map<T, Integer> submap = this.getSubmap(stack, true);
            submap.put(group, stack.field_77994_a);
        } else {
            Map<T, Integer> submap = this.getSubmap(stack, false);
            if (submap != null && submap.containsKey(group)) {
                submap.remove(group);
                if (submap.isEmpty()) {
                    this.map.remove(new HashableItemWithoutSize(stack));
                }
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.map.clear();
        NBTTagList nbttaglist = nbttagcompound.func_150295_c(this.nbtKey, 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound tagList = nbttaglist.func_150305_b(i);
            ItemStack stack = TjUtil.readLargeItemStackFromNBT(tagList);
            if (stack == null || stack.field_77994_a <= 0) continue;
            T group = this.getGroupFromNBT(tagList);
            try {
                assert (group != null);
                this.set(group, stack);
                continue;
            }
            catch (Exception ex) {
                TjUtil.printError("Group data could not be loaded from NBT. Associated item/request may be lost and won't be saved.");
                ex.printStackTrace();
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (Map.Entry<HashableItemWithoutSize, Map<T, Integer>> entry : this.map.entrySet()) {
            Map<T, Integer> submap = entry.getValue();
            if (submap.isEmpty()) continue;
            HashableItemWithoutSize item = entry.getKey();
            for (Map.Entry<T, Integer> subentry : submap.entrySet()) {
                T group = subentry.getKey();
                ItemStack stack = item.getItemStack(subentry.getValue());
                NBTTagCompound tagList = new NBTTagCompound();
                TjUtil.writeLargeItemStackToNBT(stack, tagList);
                this.saveGroupToNBT(tagList, group);
                nbttaglist.func_74742_a((NBTBase)tagList);
            }
        }
        nbttagcompound.func_74782_a(this.nbtKey, (NBTBase)nbttaglist);
    }

    protected abstract T getGroupFromNBT(NBTTagCompound var1);

    protected abstract void saveGroupToNBT(NBTTagCompound var1, T var2);

    private Map<T, Integer> getSubmap(ItemStack stack, boolean createIfMissing) {
        HashableItemWithoutSize item = new HashableItemWithoutSize(stack);
        Map<T, Integer> submap = this.map.get(item);
        if (submap == null && createIfMissing) {
            submap = new HashMap<T, Integer>();
            this.map.put(item, submap);
        }
        return submap;
    }

    private static NBTTagCompound writeLargeItemStackToNBT(ItemStack stack, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
        nbt.func_74768_a("Count", stack.field_77994_a);
        nbt.func_74777_a("Damage", (short)stack.func_77960_j());
        if (stack.field_77990_d != null) {
            nbt.func_74782_a("tag", (NBTBase)stack.field_77990_d);
        }
        return nbt;
    }
}

