/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.pipe;

import gregtech.GTMod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HarvestTool;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.render.TextureFactory;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.pipe.IActivePipe;
import tectech.mechanics.pipe.PipeActivity;

public abstract class MTEBaseFactoryPipe
extends MetaPipeEntity
implements IActivePipe {
    public static final IIconContainer EM_PIPE = new Textures.BlockIcons.CustomIcon("iconsets/EM_DATA");
    public static final IIconContainer EM_BAR = new Textures.BlockIcons.CustomIcon("iconsets/EM_BAR");
    public static final IIconContainer EM_BAR_ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/EM_BAR_ACTIVE");
    protected boolean mIsActive;
    protected float mThickness = 0.5f;
    private boolean prevActivity;

    public MTEBaseFactoryPipe(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 0);
    }

    protected MTEBaseFactoryPipe(MTEBaseFactoryPipe prototype) {
        super(prototype.mName, 0);
        this.mThickness = prototype.mThickness;
    }

    @Override
    public abstract IMetaTileEntity newMetaEntity(IGregTechTileEntity var1);

    @Override
    public ITexture[] getTexture(IGregTechTileEntity base, ForgeDirection side, int aConnections, int colorIndex, boolean aConnected, boolean aRedstone) {
        ArrayList<ITexture> textures = new ArrayList<ITexture>(2);
        textures.add(TextureFactory.builder().addIcon(EM_PIPE).setRGBA(Dyes.getModulation(colorIndex, Dyes.MACHINE_METAL.getRGBA())).build());
        if (this.getActive()) {
            textures.add(TextureFactory.builder().addIcon(EM_BAR).setRGBA(Dyes.getModulation(colorIndex, Dyes.MACHINE_METAL.getRGBA())).build());
        }
        return textures.toArray(new ITexture[0]);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public void loadNBTData(NBTTagCompound nbtTagCompound) {
        this.setActive(nbtTagCompound.func_74767_n("eActive"));
        this.mConnections = nbtTagCompound.func_74771_c("mConnections");
    }

    @Override
    public void saveNBTData(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74757_a("eActive", this.getActive());
        nbtTagCompound.func_74774_a("mConnections", this.mConnections);
    }

    @Override
    public boolean renderInside(ForgeDirection side) {
        return false;
    }

    @Override
    public byte getTileEntityBaseType() {
        return HarvestTool.WrenchPipeLevel0.toTileEntityBaseType();
    }

    @Override
    public String[] getDescription() {
        return GTValues.emptyStringArray;
    }

    @Override
    public float getCollisionThickness() {
        return this.mThickness;
    }

    @Override
    public void markUsed() {
        this.setActive(true);
    }

    @Override
    public void setActive(boolean state) {
        if (state != this.mIsActive) {
            this.mIsActive = state;
            this.getBaseMetaTileEntity().issueTextureUpdate();
        }
    }

    @Override
    public boolean getActive() {
        return this.mIsActive;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity base) {
        super.onFirstTick(base);
        this.onPostTick(base, 31L);
    }

    @Override
    public void onPostTick(IGregTechTileEntity base, long aTick) {
        super.onPostTick(base, aTick);
        if (base.isServerSide()) {
            if (this.mCheckConnections && base.isServerSide()) {
                this.mCheckConnections = false;
                this.checkConnections();
            }
            if (aTick % 20L == 0L) {
                this.checkActive();
                boolean isActive = this.getActive();
                if (isActive != this.prevActivity || aTick % 1200L == 0L) {
                    this.prevActivity = isActive;
                    PipeActivity.enqueueUpdate(base.getWorld(), base.getXCoord(), base.getYCoord(), base.getZCoord(), isActive);
                }
            }
        } else if (GTMod.clientProxy().changeDetected() == 4) {
            base.issueTextureUpdate();
        }
    }

    protected void checkActive() {
        this.mIsActive = false;
    }

    @Override
    protected void checkConnections() {
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{this.getActive() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"tt.infodata.pipe.active") : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"tt.infodata.pipe.inactive")};
    }
}

