/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.recipe.RecipeMaps;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RecipeGenExtruder
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenExtruder(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        ItemStack itemIngot = material.getIngot(1);
        ItemStack itemPlate = material.getPlate(1);
        ItemStack itemGear = material.getGear(1);
        ItemStack shape_Plate = ItemList.Shape_Extruder_Plate.get(0L, new Object[0]);
        ItemStack shape_Ring = ItemList.Shape_Extruder_Ring.get(0L, new Object[0]);
        ItemStack shape_Gear = ItemList.Shape_Extruder_Gear.get(0L, new Object[0]);
        ItemStack shape_Rod = ItemList.Shape_Extruder_Rod.get(0L, new Object[0]);
        ItemStack shape_Bolt = ItemList.Shape_Extruder_Bolt.get(0L, new Object[0]);
        ItemStack shape_Block = ItemList.Shape_Extruder_Block.get(0L, new Object[0]);
        ItemStack shape_Ingot = ItemList.Shape_Extruder_Ingot.get(0L, new Object[0]);
        Logger.WARNING("Generating Extruder recipes for " + material.getLocalizedName());
        if (material.getIngot(1) != null && material.getBlock(1) != null) {
            GTValues.RA.stdBuilder().itemInputs(material.getBlock(1), shape_Ingot).itemOutputs(material.getIngot(9)).duration((int)Math.max(material.getMass() * 2L * 1L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            Logger.WARNING("Extruder Ingot Recipe: " + material.getLocalizedName() + " - Success");
            GTValues.RA.stdBuilder().itemInputs(material.getIngot(9), shape_Block).itemOutputs(material.getBlock(1)).duration((int)Math.max(material.getMass() * 2L * 1L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            Logger.WARNING("Extruder Block Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (material.getIngot(1) != null && material.getPlate(1) != null) {
            GTValues.RA.stdBuilder().itemInputs(itemIngot, shape_Plate).itemOutputs(itemPlate).duration(10).eut(material.vVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            Logger.WARNING("Extruder Plate Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (material.getIngot(1) != null && material.getRing(1) != null && !material.isRadioactive) {
            GTValues.RA.stdBuilder().itemInputs(itemIngot, shape_Ring).itemOutputs(material.getRing(4)).duration((int)Math.max(material.getMass() * 2L * 1L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            Logger.WARNING("Extruder Ring Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (material.getIngot(1) != null && material.getGear(1) != null && !material.isRadioactive) {
            GTValues.RA.stdBuilder().itemInputs(material.getIngot(4), shape_Gear).itemOutputs(itemGear).duration((int)Math.max(material.getMass() * 5L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            Logger.WARNING("Extruder Gear Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (material.getIngot(1) != null && material.getRod(1) != null) {
            GTValues.RA.stdBuilder().itemInputs(itemIngot, shape_Rod).itemOutputs(material.getRod(2)).duration((int)Math.max(material.getMass() * 2L * 1L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            Logger.WARNING("Extruder Rod Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (material.getIngot(1) != null && material.getBolt(1) != null && !material.isRadioactive) {
            GTValues.RA.stdBuilder().itemInputs(itemIngot, shape_Bolt).itemOutputs(material.getBolt(8)).duration((int)Math.max(material.getMass() * 2L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            Logger.WARNING("Extruder Bolt Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (material.getIngot(1) != null && material.getRotor(1) != null) {
            GTValues.RA.stdBuilder().itemInputs(material.getIngot(5), ItemList.Shape_Extruder_Rotor.get(0L, new Object[0])).itemOutputs(material.getRotor(1)).duration((int)Math.max(material.getMass() * 5L * 1L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            Logger.WARNING("Extruder Rotor Recipe: " + material.getLocalizedName() + " - Success");
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

