/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.ore;

import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTUtility;
import gregtech.api.util.StringUtils;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.item.base.ore.BaseOreComponent;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BaseItemMilledOre
extends BaseOreComponent {
    public BaseItemMilledOre(Material material, int materialEU) {
        super(material, BaseOreComponent.ComponentTypes.MILLED);
        ItemStack rawStack = material.getRawOre(16);
        ItemStack crushedStack = material.getCrushed(16);
        ItemStack millingBall_Alumina = GregtechItemList.Milling_Ball_Alumina.get(0L, new Object[0]);
        ItemStack millingBall_Soapstone = GregtechItemList.Milling_Ball_Soapstone.get(0L, new Object[0]);
        for (OrePrefixes tPrefix : OrePrefixes.values()) {
            if (!tPrefix.name().startsWith("ore") || tPrefix == OrePrefixes.orePoor || tPrefix == OrePrefixes.oreSmall || tPrefix == OrePrefixes.oreNormal || tPrefix == OrePrefixes.oreRich || tPrefix == OrePrefixes.oreDense || tPrefix == OrePrefixes.oreEnd || tPrefix == OrePrefixes.oreNether) continue;
            boolean tIsRich = GTMod.proxy.mNetherOreYieldMultiplier && tPrefix == OrePrefixes.oreNetherrack || GTMod.proxy.mEndOreYieldMultiplier && tPrefix == OrePrefixes.oreEndstone;
            ItemStack oreStack = ItemUtils.getItemStackOfAmountFromOreDictNoBroken(tPrefix.name() + StringUtils.sanitizeString(material.getUnlocalizedName()), tIsRich ? 8 : 16);
            if (oreStack == null) continue;
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(11), oreStack, millingBall_Soapstone).itemOutputs(material.getMilled(48)).duration(3000).eut(materialEU).addTo(GTPPRecipeMaps.millingRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(10), oreStack, millingBall_Alumina).itemOutputs(material.getMilled(64)).duration(2400).eut(materialEU).addTo(GTPPRecipeMaps.millingRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(12), rawStack, millingBall_Soapstone).itemOutputs(material.getMilled(48)).duration(3000).eut(materialEU).addTo(GTPPRecipeMaps.millingRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(12), rawStack, millingBall_Alumina).itemOutputs(material.getMilled(64)).duration(2400).eut(materialEU).addTo(GTPPRecipeMaps.millingRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(11), crushedStack, millingBall_Soapstone).itemOutputs(material.getMilled(16)).duration(1500).eut(materialEU).addTo(GTPPRecipeMaps.millingRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(10), crushedStack, millingBall_Alumina).itemOutputs(material.getMilled(32)).duration(1200).eut(materialEU).addTo(GTPPRecipeMaps.millingRecipes);
    }

    public BaseItemMilledOre(Material material, int materialEU, ItemStack custom) {
        super(material, BaseOreComponent.ComponentTypes.MILLED);
        ItemStack millingBall_Alumina = GregtechItemList.Milling_Ball_Alumina.get(0L, new Object[0]);
        ItemStack millingBall_Soapstone = GregtechItemList.Milling_Ball_Soapstone.get(0L, new Object[0]);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(10), custom, millingBall_Alumina).itemOutputs(material.getMilled(32)).duration(1200).eut(materialEU).addTo(GTPPRecipeMaps.millingRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(11), custom, millingBall_Soapstone).itemOutputs(material.getMilled(16)).duration(1200).eut(materialEU).addTo(GTPPRecipeMaps.millingRecipes);
    }

    public static Item generate(Materials aMat, int aMaterialEU) {
        return BaseItemMilledOre.generate(MaterialUtils.generateMaterialFromGtENUM(aMat), aMaterialEU);
    }

    public static Item generate(Materials aMat, int aMaterialEU, ItemStack custom) {
        return BaseItemMilledOre.generate(MaterialUtils.generateMaterialFromGtENUM(aMat), aMaterialEU, custom);
    }

    public static Item generate(Material aMat, int aMaterialEU) {
        return new BaseItemMilledOre(aMat, aMaterialEU);
    }

    public static Item generate(Material aMat, int aMaterialEU, ItemStack custom) {
        return new BaseItemMilledOre(aMat, aMaterialEU, custom);
    }
}

