/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.cell;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.config.Configuration;
import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BaseItemCell
extends BaseItemComponent {
    BaseItemComponent.ComponentTypes Cell = BaseItemComponent.ComponentTypes.CELL;
    private final short[] fluidColour;
    boolean upwards = true;

    public BaseItemCell(Material material) {
        super(material, BaseItemComponent.ComponentTypes.CELL);
        this.fluidColour = material.getRGBA();
    }

    public BaseItemCell(String unlocalName, String localName, short[] RGBa) {
        super(unlocalName, localName, RGBa);
        this.fluidColour = RGBa;
        FluidStack aFluid = FluidUtils.getFluidStack(unlocalName.toLowerCase(), 1000);
        if (aFluid != null) {
            FluidContainerRegistry.registerFluidContainer((FluidStack)aFluid, (ItemStack)new ItemStack((Item)this), (ItemStack)ItemList.Cell_Empty.get(1L, new Object[0]));
        }
    }

    public BaseItemCell(String unlocalName, String localName, short[] RGBa, Fluid cellFluid) {
        super(unlocalName, localName, RGBa);
        this.fluidColour = RGBa;
        FluidContainerRegistry.registerFluidContainer((FluidStack)FluidUtils.getFluidStack(cellFluid, 1000), (ItemStack)new ItemStack((Item)this), (ItemStack)ItemList.Cell_Empty.get(1L, new Object[0]));
    }

    @Override
    public void func_94581_a(IIconRegister i) {
        if (Configuration.visual.useGregtechTextures) {
            this.base = i.func_94245_a(Mods.GregTech.ID + ":materialicons/METALLIC/cell");
            this.overlay = i.func_94245_a(Mods.GregTech.ID + ":materialicons/METALLIC/cell_OVERLAY");
        } else {
            this.base = i.func_94245_a(Mods.GTPlusPlus.ID + ":item" + this.Cell.getComponent());
            this.overlay = i.func_94245_a(Mods.GTPlusPlus.ID + ":item" + this.Cell.getComponent() + "_Overlay");
        }
    }

    @Override
    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass == 0 && !Configuration.visual.useGregtechTextures) {
            return Utils.rgbtoHexValue(230, 230, 230);
        }
        if (renderPass == 1 && Configuration.visual.useGregtechTextures) {
            return Utils.rgbtoHexValue(230, 230, 230);
        }
        return this.componentColour;
    }
}

