/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.machine;

import com.cleanroommc.modularui.factory.GuiFactories;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.interfaces.ITileTooltip;
import gtPlusPlus.core.client.renderer.RenderDecayChest;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.base.itemblock.ItemBlockBasicTile;
import gtPlusPlus.core.tileentities.general.TileEntityDecayablesChest;
import gtPlusPlus.core.util.minecraft.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDecayablesChest
extends BlockContainer
implements ITileTooltip {
    private static final ForgeDirection[] validRotationAxes = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    private final int mTooltipID = 3;

    @Override
    public int getTooltipID() {
        return this.mTooltipID;
    }

    public BlockDecayablesChest() {
        super(Material.field_151573_f);
        this.func_149663_c("blockDecayablesChest");
        this.func_149647_a(AddToCreativeTab.tabMachines);
        this.func_149711_c(5.0f);
        this.func_149752_b(1.0f);
        GameRegistry.registerBlock((Block)this, ItemBlockBasicTile.class, (String)"blockDecayablesChest");
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        try {
            if (RenderDecayChest.INSTANCE != null) {
                return RenderDecayChest.INSTANCE.mRenderID;
            }
            return super.func_149645_b();
        }
        catch (NullPointerException n) {
            return 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a(Mods.GTPlusPlus.ID + ":TileEntities/DecayablesChest_top");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float lx, float ly, float lz) {
        if (world.field_72995_K || player == null || player.field_70170_p != world) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityDecayablesChest) {
            GuiFactories.tileEntity().open(player, x, y, z);
            return true;
        }
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntityDecayablesChest();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int number) {
        InventoryUtils.dropInventoryItems(world, x, y, z, block);
        super.func_149749_a(world, x, y, z, block, number);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity te;
        int chestFacing = 0;
        int facing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (facing == 0) {
            chestFacing = 2;
        }
        if (facing == 1) {
            chestFacing = 5;
        }
        if (facing == 2) {
            chestFacing = 3;
        }
        if (facing == 3) {
            chestFacing = 4;
        }
        if ((te = world.func_147438_o(x, y, z)) instanceof TileEntityDecayablesChest) {
            TileEntityDecayablesChest tileEntityChest = (TileEntityDecayablesChest)te;
            tileEntityChest.setFacing(chestFacing);
            world.func_147471_g(x, y, z);
        }
        if (stack.func_82837_s()) {
            ((TileEntityDecayablesChest)world.func_147438_o(x, y, z)).setCustomName(stack.func_82833_r());
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        return validRotationAxes;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            TileEntity tileEntity = worldObj.func_147438_o(x, y, z);
            if (tileEntity instanceof TileEntityDecayablesChest) {
                TileEntityDecayablesChest tileEntityChest = (TileEntityDecayablesChest)tileEntity;
                tileEntityChest.rotateAround(axis);
            }
            return true;
        }
        return false;
    }
}

