/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeRegistrator;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;

public class ProcessingNugget
implements IOreRecipeRegistrator {
    public ProcessingNugget() {
        OrePrefixes.nugget.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aMaterial == Materials.Calcium || aMaterial == Materials.Magnesia) {
            return;
        }
        if (aMaterial.contains(SubTag.SMELTING_TO_GEM) && GTOreDictUnificator.get(OrePrefixes.gem, aMaterial.mSmeltInto, 1L) != null) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack), ItemList.Shape_Mold_Ball.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial.mSmeltInto, 1L)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, 2)).addTo(RecipeMaps.alloySmelterRecipes);
        }
        if (!aMaterial.contains(SubTag.SMELTING_TO_GEM) && GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, 1L) != null && aMaterial != Materials.Aluminium) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack), ItemList.Shape_Mold_Ingot.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, 1L)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, 2)).recipeCategory(RecipeCategories.alloySmelterMolding).addTo(RecipeMaps.alloySmelterRecipes);
        }
        if (aMaterial.mStandardMoltenFluid != null && aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron) {
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Nugget.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.nugget, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(16L)).duration(16).eut(GTUtility.calculateRecipeEU(aMaterial, 4)).addTo(RecipeMaps.fluidSolidifierRecipes);
        }
        GTRecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null, true);
        GTRecipeRegistrator.registerReverseMacerating(aStack, aMaterial, aPrefix.mMaterialAmount, null, null, null, false, true);
        if (!aMaterial.contains(SubTag.NO_SMELTING) && GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L) != null) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L), ItemList.Shape_Mold_Nugget.get(0L, new Object[0])).itemOutputs(GTUtility.copyAmount(9, aStack)).duration(100).eut(GTUtility.calculateRecipeEU(aMaterial, 1)).recipeCategory(RecipeCategories.alloySmelterMolding).addTo(RecipeMaps.alloySmelterRecipes);
            if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.nugget, aMaterial, 8L), GTModHandler.RecipeBits.BUFFERED, new Object[]{"sI ", Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
            }
        }
    }
}

