/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.covers.CoverContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.covers.modes.BlockMode;
import gregtech.common.covers.modes.MachineProcessingCondition;
import gregtech.common.covers.modes.TransferMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;

public abstract class CoverIOBase
extends CoverLegacyData {
    protected CoverIOBase(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public TransferMode getIOMode() {
        return (1 & this.coverData) == 1 ? TransferMode.IMPORT : TransferMode.EXPORT;
    }

    public void setIOMode(TransferMode mode) {
        int n;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EXPORT: {
                n = this.coverData & 0xFFFFFFFE;
                break;
            }
            case IMPORT: {
                n = this.coverData | 1;
            }
        }
        this.coverData = n;
    }

    public MachineProcessingCondition getMachineProcessingCondition() {
        if (this.coverData % 6 < 2) {
            return MachineProcessingCondition.ALWAYS;
        }
        if (this.coverData % 6 == 2 || this.coverData % 6 == 3) {
            return MachineProcessingCondition.CONDITIONAL;
        }
        return MachineProcessingCondition.INVERTED;
    }

    public void setMachineProcessingCondition(MachineProcessingCondition mode) {
        int n;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALWAYS: {
                if (this.coverData > 5) {
                    n = 6 | this.coverData & 0xFFFFFFF1;
                    break;
                }
                n = this.coverData & 0xFFFFFFF1;
                break;
            }
            case CONDITIONAL: {
                if (this.coverData > 5) {
                    n = 8 | this.coverData & 0xFFFFFFF1;
                    break;
                }
                n = 2 | this.coverData & 0xFFFFFFF1;
                break;
            }
            case INVERTED: {
                n = this.coverData > 5 ? 0xA | this.coverData & 0xFFFFFFF1 : 4 | this.coverData & 0xFFFFFFF1;
            }
        }
        this.coverData = n;
    }

    public BlockMode getBlockMode() {
        return this.coverData < 6 ? BlockMode.BLOCK : BlockMode.ALLOW;
    }

    public void setBlockMode(BlockMode mode) {
        int n;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALLOW: {
                if (this.coverData <= 5) {
                    n = this.coverData + 6;
                    break;
                }
                n = this.coverData;
                break;
            }
            case BLOCK: {
                n = this.coverData > 5 ? this.coverData - 6 : this.coverData;
            }
        }
        this.coverData = n;
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        IMachineProgress machine;
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        if (this.coverData % 6 > 1 && coverable instanceof IMachineProgress && (machine = (IMachineProgress)((Object)coverable)).isAllowedToWork() != this.coverData % 6 < 4) {
            return;
        }
        this.doTransfer(coverable);
    }

    protected abstract void doTransfer(ICoverable var1);

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.coverData = (this.coverData + (aPlayer.func_70093_af() ? -1 : 1)) % 12;
        if (this.coverData < 0) {
            this.coverData = 11;
        }
        switch (this.coverData) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.export"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.import"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.export_cond"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.import_cond"));
                break;
            }
            case 4: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.export_invert_cond"));
                break;
            }
            case 5: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.import_invert_cond"));
                break;
            }
            case 6: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.export_allow"));
                break;
            }
            case 7: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.import_allow"));
                break;
            }
            case 8: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.export_allow_cond"));
                break;
            }
            case 9: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.import_allow_cond"));
                break;
            }
            case 10: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.export_allow_invert_cond"));
                break;
            }
            case 11: {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.interact.desc.import_allow_invert_cond"));
            }
        }
    }
}

