/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.tileentity.IRecipeLockable;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SingleRecipeCheck;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.VoidProtectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ParallelHelper {
    protected static final double MAX_BATCH_MODE_TICK_TIME = 128.0;
    protected IVoidable machine;
    protected IRecipeLockable singleRecipeMachine;
    protected boolean isRecipeLocked;
    protected GTRecipe recipe;
    protected long availableEUt;
    protected int currentParallel = 0;
    protected int maxParallel = 1;
    protected int batchModifier = 1;
    protected ItemStack[] itemInputs;
    protected ItemStack[] itemOutputs;
    protected FluidStack[] fluidInputs;
    protected FluidStack[] fluidOutputs;
    protected boolean protectExcessItem;
    protected boolean protectExcessFluid;
    protected boolean consume;
    protected boolean batchMode;
    protected boolean calculateOutputs;
    protected boolean built;
    protected double durationMultiplier;
    protected double eutModifier = 1.0;
    protected double chanceMultiplier = 1.0;
    protected MaxParallelCalculator maxParallelCalculator = GTRecipe::maxParallelCalculatedByInputs;
    protected InputConsumer inputConsumer = GTRecipe::consumeInput;
    protected OverclockCalculator calculator;
    @Nonnull
    protected CheckRecipeResult result = CheckRecipeResultRegistry.NONE;
    protected Function<Integer, ItemStack[]> customItemOutputCalculation;
    protected Function<Integer, FluidStack[]> customFluidOutputCalculation;

    @Nonnull
    public ParallelHelper setMachine(IVoidable machine) {
        return this.setMachine(machine, machine.protectsExcessItem(), machine.protectsExcessFluid());
    }

    @Nonnull
    public ParallelHelper setMachine(IVoidable machine, boolean protectExcessItem, boolean protectExcessFluid) {
        this.protectExcessItem = protectExcessItem;
        this.protectExcessFluid = protectExcessFluid;
        this.machine = machine;
        return this;
    }

    @Nonnull
    public ParallelHelper setRecipe(@Nonnull GTRecipe aRecipe) {
        this.recipe = Objects.requireNonNull(aRecipe);
        return this;
    }

    @Nonnull
    public ParallelHelper setRecipeLocked(IRecipeLockable singleRecipeMachine, boolean isRecipeLocked) {
        this.singleRecipeMachine = singleRecipeMachine;
        this.isRecipeLocked = isRecipeLocked;
        return this;
    }

    @Nonnull
    public ParallelHelper setItemInputs(ItemStack ... aItemInputs) {
        this.itemInputs = aItemInputs;
        return this;
    }

    @Nonnull
    public ParallelHelper setFluidInputs(FluidStack ... aFluidInputs) {
        this.fluidInputs = aFluidInputs;
        return this;
    }

    @Nonnull
    public ParallelHelper setAvailableEUt(long aAvailableEUt) {
        this.availableEUt = aAvailableEUt;
        return this;
    }

    @Nonnull
    public ParallelHelper setEUtModifier(double aEUtModifier) {
        this.eutModifier = aEUtModifier;
        return this;
    }

    @Nonnull
    public ParallelHelper setChanceMultiplier(double chanceMultiplier) {
        this.chanceMultiplier = chanceMultiplier;
        return this;
    }

    @Nonnull
    public ParallelHelper setCalculator(OverclockCalculator calculator) {
        this.calculator = calculator;
        return this;
    }

    @Nonnull
    public ParallelHelper setConsumption(boolean consume) {
        this.consume = consume;
        return this;
    }

    @Nonnull
    public ParallelHelper setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
        return this;
    }

    @Nonnull
    public ParallelHelper enableBatchMode(int batchModifier) {
        this.batchMode = batchModifier > 1;
        this.batchModifier = batchModifier;
        return this;
    }

    @Nonnull
    public ParallelHelper setOutputCalculation(boolean calculateOutputs) {
        this.calculateOutputs = calculateOutputs;
        return this;
    }

    @Nonnull
    public ParallelHelper setCustomItemOutputCalculation(Function<Integer, ItemStack[]> custom) {
        this.customItemOutputCalculation = custom;
        return this;
    }

    @Nonnull
    public ParallelHelper setCustomFluidOutputCalculation(Function<Integer, FluidStack[]> custom) {
        this.customFluidOutputCalculation = custom;
        return this;
    }

    public ParallelHelper setMaxParallelCalculator(MaxParallelCalculator maxParallelCalculator) {
        this.maxParallelCalculator = maxParallelCalculator;
        return this;
    }

    public ParallelHelper setInputConsumer(InputConsumer inputConsumer) {
        this.inputConsumer = inputConsumer;
        return this;
    }

    @Nonnull
    public ParallelHelper build() {
        if (this.built) {
            throw new IllegalStateException("Tried to build twice");
        }
        if (this.recipe == null) {
            throw new IllegalStateException("Recipe is not set");
        }
        this.built = true;
        this.determineParallel();
        return this;
    }

    public int getCurrentParallel() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get parallels before building");
        }
        return this.currentParallel;
    }

    public double getDurationMultiplierDouble() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get duration multiplier before building");
        }
        if (this.batchMode && this.durationMultiplier > 0.0) {
            return this.durationMultiplier;
        }
        return 1.0;
    }

    @Nonnull
    public ItemStack[] getItemOutputs() {
        if (!this.built || !this.calculateOutputs) {
            throw new IllegalStateException("Tried to get item outputs before building or without enabling calculation of outputs");
        }
        return this.itemOutputs;
    }

    @Nonnull
    public FluidStack[] getFluidOutputs() {
        if (!this.built || !this.calculateOutputs) {
            throw new IllegalStateException("Tried to get fluid outputs before building or without enabling calculation of outputs");
        }
        return this.fluidOutputs;
    }

    @Nonnull
    public CheckRecipeResult getResult() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get recipe result before building");
        }
        return this.result;
    }

    protected void determineParallel() {
        int actualMaxParallel;
        RecipeMap<?> recipeMap;
        double heatDiscountMultiplier;
        int tRecipeEUt;
        if (this.maxParallel <= 0) {
            return;
        }
        if (this.itemInputs == null) {
            this.itemInputs = GTValues.emptyItemStackArray;
        }
        if (this.fluidInputs == null) {
            this.fluidInputs = GTValues.emptyFluidStackArray;
        }
        if (!this.consume) {
            this.copyInputs();
        }
        if (this.calculator == null) {
            this.calculator = new OverclockCalculator().setEUt(this.availableEUt).setRecipeEUt(this.recipe.mEUt).setDuration(this.recipe.mDuration).setEUtDiscount(this.eutModifier);
        }
        if (this.availableEUt < (long)(tRecipeEUt = (int)Math.ceil((double)this.recipe.mEUt * this.eutModifier * (heatDiscountMultiplier = this.calculator.calculateHeatDiscountMultiplier())))) {
            this.result = CheckRecipeResultRegistry.insufficientPower(tRecipeEUt);
            return;
        }
        if (!this.calculator.getAllowedTierSkip()) {
            this.result = CheckRecipeResultRegistry.insufficientVoltage(tRecipeEUt);
            return;
        }
        int originalMaxParallel = this.maxParallel;
        this.calculator.setParallel(originalMaxParallel);
        if (this.calculator.hasDurationUnderOneTickSupplier()) {
            if (this.calculator.getDurationUnderOneTickSupplier() < 1.0) {
                this.maxParallel = GTUtility.safeInt((long)((double)this.maxParallel / this.calculator.getDurationUnderOneTickSupplier()), 0);
            }
        } else {
            this.maxParallel = GTUtility.safeInt((long)((double)this.maxParallel * this.calculator.calculateMultiplierUnderOneTick()), 0);
        }
        int maxParallelBeforeBatchMode = this.maxParallel;
        if (this.batchMode) {
            this.maxParallel = GTUtility.safeInt((long)this.maxParallel * (long)this.batchModifier, 0);
        }
        ItemStack[] truncatedItemOutputs = this.recipe.mOutputs != null ? Arrays.copyOfRange(this.recipe.mOutputs, 0, Math.min(this.machine.getItemOutputLimit(), this.recipe.mOutputs.length)) : GTValues.emptyItemStackArray;
        FluidStack[] truncatedFluidOutputs = this.recipe.mFluidOutputs != null ? Arrays.copyOfRange(this.recipe.mFluidOutputs, 0, Math.min(this.machine.getFluidOutputLimit(), this.recipe.mFluidOutputs.length)) : GTValues.emptyFluidStackArray;
        SingleRecipeCheck recipeCheck = null;
        SingleRecipeCheck.Builder tSingleRecipeCheckBuilder = null;
        if (this.isRecipeLocked && this.singleRecipeMachine != null && (recipeCheck = this.singleRecipeMachine.getSingleRecipeCheck()) == null && (recipeMap = this.singleRecipeMachine.getRecipeMap()) != null) {
            tSingleRecipeCheckBuilder = SingleRecipeCheck.builder(recipeMap).setBefore(this.itemInputs, this.fluidInputs);
        }
        if (this.protectExcessItem || this.protectExcessFluid) {
            if (this.machine == null) {
                throw new IllegalStateException("Tried to calculate void protection, but machine is not set");
            }
            VoidProtectionHelper voidProtectionHelper = new VoidProtectionHelper();
            voidProtectionHelper.setMachine(this.machine).setItemOutputs(truncatedItemOutputs).setFluidOutputs(truncatedFluidOutputs).setChangeGetter(this.recipe::getOutputChance).setChanceMultiplier(this.chanceMultiplier).setMaxParallel(this.maxParallel).build();
            this.maxParallel = Math.min(voidProtectionHelper.getMaxParallel(), this.maxParallel);
            if (voidProtectionHelper.isItemFull()) {
                this.result = CheckRecipeResultRegistry.ITEM_OUTPUT_FULL;
                return;
            }
            if (voidProtectionHelper.isFluidFull()) {
                this.result = CheckRecipeResultRegistry.FLUID_OUTPUT_FULL;
                return;
            }
        }
        maxParallelBeforeBatchMode = Math.min(this.maxParallel, maxParallelBeforeBatchMode);
        int n = actualMaxParallel = tRecipeEUt > 0 ? (int)Math.min((long)maxParallelBeforeBatchMode, this.availableEUt / (long)tRecipeEUt) : maxParallelBeforeBatchMode;
        if (recipeCheck != null) {
            this.currentParallel = recipeCheck.checkRecipeInputs(true, actualMaxParallel, this.itemInputs, this.fluidInputs);
        } else {
            this.currentParallel = (int)this.maxParallelCalculator.calculate(this.recipe, actualMaxParallel, this.fluidInputs, this.itemInputs);
            if (this.currentParallel > 0) {
                if (tSingleRecipeCheckBuilder != null) {
                    this.inputConsumer.consume(this.recipe, 1, this.fluidInputs, this.itemInputs);
                    SingleRecipeCheck builtCheck = tSingleRecipeCheckBuilder.setAfter(this.itemInputs, this.fluidInputs).setRecipe(this.recipe).build();
                    this.singleRecipeMachine.setSingleRecipeCheck(builtCheck);
                    this.inputConsumer.consume(this.recipe, this.currentParallel - 1, this.fluidInputs, this.itemInputs);
                } else {
                    this.inputConsumer.consume(this.recipe, this.currentParallel, this.fluidInputs, this.itemInputs);
                }
            }
        }
        if (this.currentParallel <= 0) {
            this.result = CheckRecipeResultRegistry.INTERNAL_ERROR;
            return;
        }
        this.calculator.setCurrentParallel(this.currentParallel).calculate();
        if (this.batchMode && this.currentParallel > 0 && (double)this.calculator.getDuration() < 128.0) {
            int tExtraParallels;
            double batchMultiplierMax = 128.0 / (double)this.calculator.getDuration();
            int maxExtraParallels = (int)Math.floor(Math.min((double)this.currentParallel * Math.min(batchMultiplierMax - 1.0, (double)(this.batchModifier - 1)), (double)(this.maxParallel - this.currentParallel)));
            if (recipeCheck != null) {
                tExtraParallels = recipeCheck.checkRecipeInputs(true, maxExtraParallels, this.itemInputs, this.fluidInputs);
            } else {
                tExtraParallels = (int)this.maxParallelCalculator.calculate(this.recipe, maxExtraParallels, this.fluidInputs, this.itemInputs);
                this.inputConsumer.consume(this.recipe, tExtraParallels, this.fluidInputs, this.itemInputs);
            }
            this.durationMultiplier = 1.0f + (float)tExtraParallels / (float)this.currentParallel;
            this.currentParallel += tExtraParallels;
        }
        if (this.calculateOutputs && this.currentParallel > 0) {
            this.calculateItemOutputs(truncatedItemOutputs);
            this.calculateFluidOutputs(truncatedFluidOutputs);
        }
        this.result = CheckRecipeResultRegistry.SUCCESSFUL;
    }

    protected void copyInputs() {
        int i;
        ItemStack[] itemInputsToUse = new ItemStack[this.itemInputs.length];
        for (i = 0; i < this.itemInputs.length; ++i) {
            itemInputsToUse[i] = this.itemInputs[i].func_77946_l();
        }
        FluidStack[] fluidInputsToUse = new FluidStack[this.fluidInputs.length];
        for (i = 0; i < this.fluidInputs.length; ++i) {
            fluidInputsToUse[i] = this.fluidInputs[i].copy();
        }
        this.itemInputs = itemInputsToUse;
        this.fluidInputs = fluidInputsToUse;
    }

    protected void calculateItemOutputs(ItemStack[] truncatedItemOutputs) {
        if (this.customItemOutputCalculation != null) {
            this.itemOutputs = this.customItemOutputCalculation.apply(this.currentParallel);
            return;
        }
        if (truncatedItemOutputs.length == 0) {
            return;
        }
        ArrayList<ItemStack> itemOutputsList = new ArrayList<ItemStack>();
        for (int i = 0; i < truncatedItemOutputs.length; ++i) {
            if (this.recipe.getOutput(i) == null) continue;
            ItemStack origin = this.recipe.getOutput(i).func_77946_l();
            long itemStackSize = origin.field_77994_a;
            long chancedOutputMultiplier = ParallelHelper.calculateIntegralChancedOutputMultiplier((int)((double)this.recipe.getOutputChance(i) * this.chanceMultiplier), this.currentParallel);
            long items = itemStackSize * chancedOutputMultiplier;
            ParallelHelper.addItemsLong(itemOutputsList, origin, items);
        }
        this.itemOutputs = itemOutputsList.toArray(new ItemStack[0]);
    }

    protected void calculateFluidOutputs(FluidStack[] truncatedFluidOutputs) {
        if (this.customFluidOutputCalculation != null) {
            this.fluidOutputs = this.customFluidOutputCalculation.apply(this.currentParallel);
            return;
        }
        if (truncatedFluidOutputs.length == 0) {
            return;
        }
        ArrayList<FluidStack> fluidOutputsList = new ArrayList<FluidStack>();
        for (int i = 0; i < truncatedFluidOutputs.length; ++i) {
            if (this.recipe.getFluidOutput(i) == null) continue;
            FluidStack origin = this.recipe.getFluidOutput(i).copy();
            long fluids = (long)origin.amount * (long)this.currentParallel;
            ParallelHelper.addFluidsLong(fluidOutputsList, origin, fluids);
        }
        this.fluidOutputs = fluidOutputsList.toArray(new FluidStack[0]);
    }

    public static double calculateChancedOutputMultiplier(int chanceInt, int parallel) {
        boolean isSuitableForFittingWithNormalDistribution;
        double multiplier = Math.floorDiv(chanceInt, 10000) * parallel;
        int transformedChanceInt = chanceInt % 10000;
        if (transformedChanceInt == 0) {
            return multiplier;
        }
        double chance = (double)transformedChanceInt / 10000.0;
        double mean = (double)parallel * chance;
        double stdDev = Math.sqrt((double)parallel * chance * (1.0 - chance));
        boolean bl = isSuitableForFittingWithNormalDistribution = mean - 3.0 * stdDev >= 0.0 && mean + 3.0 * stdDev <= (double)parallel;
        if (isSuitableForFittingWithNormalDistribution) {
            double tMultiplier = stdDev * XSTR.XSTR_INSTANCE.nextGaussian() + mean;
            multiplier += Math.max(Math.min(tMultiplier, (double)parallel), 0.0);
        } else {
            for (int roll = 0; roll < parallel; ++roll) {
                if (transformedChanceInt <= XSTR.XSTR_INSTANCE.nextInt(10000)) continue;
                multiplier += 1.0;
            }
        }
        return multiplier;
    }

    public static long calculateIntegralChancedOutputMultiplier(int chanceInt, int parallel) {
        double multiplier = ParallelHelper.calculateChancedOutputMultiplier(chanceInt, parallel);
        if (multiplier != Math.floor(multiplier) && multiplier - Math.floor(multiplier) > XSTR.XSTR_INSTANCE.nextDouble()) {
            return (long)multiplier + 1L;
        }
        return (long)multiplier;
    }

    public static void addItemsLong(ArrayList<ItemStack> itemList, ItemStack origin, long amount) {
        if (amount > 0L) {
            while (amount > Integer.MAX_VALUE) {
                itemList.add(GTUtility.copyAmountUnsafe(Integer.MAX_VALUE, origin));
                amount -= Integer.MAX_VALUE;
            }
            itemList.add(GTUtility.copyAmountUnsafe((int)amount, origin));
        }
    }

    public static void addFluidsLong(ArrayList<FluidStack> fluidList, FluidStack origin, long amount) {
        if (amount > 0L) {
            while (amount > Integer.MAX_VALUE) {
                fluidList.add(GTUtility.copyAmount(Integer.MAX_VALUE, origin));
                amount -= Integer.MAX_VALUE;
            }
            fluidList.add(GTUtility.copyAmount((int)amount, origin));
        }
    }

    @FunctionalInterface
    public static interface MaxParallelCalculator {
        public double calculate(GTRecipe var1, int var2, FluidStack[] var3, ItemStack[] var4);
    }

    @FunctionalInterface
    public static interface InputConsumer {
        public void consume(GTRecipe var1, int var2, FluidStack[] var3, ItemStack[] var4);
    }
}

