/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.FindRecipeQuery;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.FieldsAreNonnullByDefault;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Unmodifiable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public final class RecipeMap<B extends RecipeMapBackend>
implements IRecipeMap {
    public static final Map<String, RecipeMap<?>> ALL_RECIPE_MAPS = new HashMap();
    private final B backend;
    private final RecipeMapFrontend frontend;
    public final String unlocalizedName;
    private final RecipeCategory defaultRecipeCategory;
    private static final Pattern LEGACY_IDENTIFIER_PATTERN = Pattern.compile("(.+)_[0-9]+_[0-9]+_[0-9]+_[0-9]+_[0-9]+");

    RecipeMap(String unlocalizedName, B backend, RecipeMapFrontend frontend) {
        this.unlocalizedName = unlocalizedName;
        this.backend = backend;
        this.frontend = frontend;
        this.defaultRecipeCategory = new RecipeCategory(this);
        ((RecipeMapBackend)backend).setRecipeMap(this);
        if (ALL_RECIPE_MAPS.containsKey(unlocalizedName)) {
            throw new IllegalArgumentException("Cannot register recipemap with duplicated unlocalized name: " + unlocalizedName);
        }
        ALL_RECIPE_MAPS.put(unlocalizedName, this);
    }

    public B getBackend() {
        return this.backend;
    }

    public RecipeMapFrontend getFrontend() {
        return this.frontend;
    }

    public @Unmodifiable Collection<GTRecipe> getAllRecipes() {
        return ((RecipeMapBackend)this.backend).getAllRecipes();
    }

    public List<RecipeCategory> getAssociatedCategories() {
        return RecipeCategory.ALL_RECIPE_CATEGORIES.values().stream().filter(category -> category.recipeMap == this).collect(Collectors.toList());
    }

    public RecipeCategory getDefaultRecipeCategory() {
        return this.defaultRecipeCategory;
    }

    public int getAmperage() {
        return this.frontend.getUIProperties().amperage;
    }

    public void appendBuilderTransformer(Consumer<? super GTRecipeBuilder> builderTransformer) {
        ((RecipeMapBackend)this.backend).properties.appendBuilderTransformer(builderTransformer);
    }

    public void appendRecipeTransformer(Consumer<? super GTRecipe> recipeTransformer) {
        ((RecipeMapBackend)this.backend).properties.appendRecipeTransformer(recipeTransformer);
    }

    @Deprecated
    @Nullable
    public GTRecipe addRecipe(GTRecipe aRecipe) {
        return this.addRecipe(aRecipe, true, false, false);
    }

    @Deprecated
    @Nullable
    public GTRecipe addRecipe(GTRecipe aRecipe, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden) {
        aRecipe.mHidden = aHidden;
        aRecipe.mFakeRecipe = aFakeRecipe;
        if (aRecipe.mFluidInputs.length < ((RecipeMapBackend)this.backend).properties.minFluidInputs && aRecipe.mInputs.length < ((RecipeMapBackend)this.backend).properties.minItemInputs) {
            return null;
        }
        if (aCheckForCollisions && GTRecipeBuilder.ENABLE_COLLISION_CHECK && ((RecipeMapBackend)this.backend).checkCollision(aRecipe)) {
            return null;
        }
        return ((RecipeMapBackend)this.backend).compileRecipe(aRecipe);
    }

    @Deprecated
    @Nullable
    public GTRecipe addFakeRecipe(boolean aCheckForCollisions, @Nullable ItemStack[] aInputs, @Nullable ItemStack[] aOutputs, @Nullable Object aSpecial, @Nullable FluidStack[] aFluidInputs, @Nullable FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue, ItemStack[][] aAlt, boolean hidden) {
        return this.addFakeRecipe(aCheckForCollisions, new GTRecipe.GTRecipe_WithAlt(false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue, aAlt), hidden);
    }

    @Deprecated
    @Nullable
    public GTRecipe addFakeRecipe(boolean aCheckForCollisions, GTRecipe aRecipe) {
        return this.addRecipe(aRecipe, aCheckForCollisions, true, false);
    }

    @Deprecated
    @Nullable
    public GTRecipe addFakeRecipe(boolean aCheckForCollisions, GTRecipe aRecipe, boolean hidden) {
        return this.addRecipe(aRecipe, aCheckForCollisions, true, hidden);
    }

    @Override
    @Nonnull
    public Collection<GTRecipe> doAdd(GTRecipeBuilder builder) {
        return ((RecipeMapBackend)this.backend).doAdd(builder);
    }

    public GTRecipe add(GTRecipe aRecipe) {
        return ((RecipeMapBackend)this.backend).compileRecipe(aRecipe);
    }

    public boolean containsInput(@Nullable ItemStack aStack) {
        return aStack != null && ((RecipeMapBackend)this.backend).containsInput(aStack);
    }

    public boolean containsInput(@Nullable FluidStack aFluid) {
        return aFluid != null && this.containsInput(aFluid.getFluid());
    }

    public boolean containsInput(@Nullable Fluid aFluid) {
        return aFluid != null && ((RecipeMapBackend)this.backend).containsInput(aFluid);
    }

    public FindRecipeQuery findRecipeQuery() {
        return new FindRecipeQuery(this);
    }

    public String toString() {
        return "RecipeMap{unlocalizedName='" + this.unlocalizedName + '\'' + ", ownerMod=" + this.defaultRecipeCategory.ownerMod.getModId() + '}';
    }

    @Nullable
    public static RecipeMap<?> getFromOldIdentifier(String legacyIdentifier) {
        Matcher matcher = LEGACY_IDENTIFIER_PATTERN.matcher(legacyIdentifier);
        if (!matcher.find()) {
            return ALL_RECIPE_MAPS.get(legacyIdentifier);
        }
        return ALL_RECIPE_MAPS.get(matcher.group(1));
    }
}

