/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.api.util.GTLog;
import gregtech.client.LMACraftingFX;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GTPacketLMACraftingFX
extends GTPacket {
    private int x;
    private int y;
    private int z;
    private int age;
    private IAEItemStack itemStack;

    public GTPacketLMACraftingFX() {
    }

    public GTPacketLMACraftingFX(int x, int y, int z, int age, IAEItemStack itemStack) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.age = age;
        this.itemStack = itemStack;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.LMA_CRAFTING_FX.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.age);
        try {
            ByteBuf stackBuffer = Unpooled.buffer();
            this.itemStack.writeToPacket(stackBuffer);
            byte[] data = stackBuffer.array();
            buffer.writeInt(data.length);
            buffer.writeBytes(data);
        }
        catch (IOException e) {
            GTLog.out.println("Could not serialize LMA ItemStack");
            e.printStackTrace();
        }
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        IAEItemStack itemStack;
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        int age = buffer.readInt();
        byte[] data = new byte[buffer.readInt()];
        buffer.readFully(data);
        ByteBuf stackBuffer = Unpooled.wrappedBuffer((byte[])data);
        try {
            itemStack = AEItemStack.loadItemStackFromPacket((ByteBuf)stackBuffer);
        }
        catch (IOException e) {
            GTLog.out.println("Could not deserialize LMA ItemStack");
            throw new IllegalStateException(e);
        }
        return new GTPacketLMACraftingFX(x, y, z, age, itemStack);
    }

    @Override
    public void process(IBlockAccess world) {
        if (world != null) {
            this.spawnFX();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFX() {
        LMACraftingFX fx = new LMACraftingFX((World)Minecraft.func_71410_x().field_71441_e, this.x, this.y, this.z, this.age, this.itemStack);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }
}

