/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.factory;

import com.gtnewhorizon.gtnhlib.util.ObjectPooler;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.world.World;
import org.joml.Vector4i;

public class BlockData<T>
extends HashMap<Vector4i, T> {
    private final ObjectPooler<Vector4i> pooler = new ObjectPooler(Vector4i::new);

    public T get(IMetaTileEntity imte) {
        return imte.getBaseMetaTileEntity() != null ? (T)this.get(imte.getBaseMetaTileEntity()) : null;
    }

    public T get(IGregTechTileEntity igte) {
        return this.get(igte.getWorld(), igte.getXCoord(), igte.getYCoord(), igte.getZCoord());
    }

    public T get(World world, int x, int y, int z) {
        Vector4i key = (Vector4i)this.pooler.getInstance();
        key.w = world.field_73011_w.field_76574_g;
        key.x = x;
        key.y = y;
        key.z = z;
        Object t = this.get(key);
        this.pooler.releaseInstance((Object)key);
        return (T)t;
    }

    public void set(IMetaTileEntity imte, T t) {
        if (imte.getBaseMetaTileEntity() != null) {
            this.set(imte.getBaseMetaTileEntity(), t);
        }
    }

    public void set(IGregTechTileEntity igte, T t) {
        this.set(igte.getWorld(), igte.getXCoord(), igte.getYCoord(), igte.getZCoord(), t);
    }

    public T set(World world, int x, int y, int z, T t) {
        Vector4i key = (Vector4i)this.pooler.getInstance();
        key.w = world.field_73011_w.field_76574_g;
        key.x = x;
        key.y = y;
        key.z = z;
        T old = this.put(key, t);
        this.pooler.releaseInstance((Object)key);
        return old;
    }

    public T remove(World world, int x, int y, int z) {
        Vector4i key = (Vector4i)this.pooler.getInstance();
        key.w = world.field_73011_w.field_76574_g;
        key.x = x;
        key.y = y;
        key.z = z;
        Object removed = this.remove(key);
        this.pooler.releaseInstance((Object)key);
        return (T)removed;
    }

    public T remove(IMetaTileEntity mte) {
        IGregTechTileEntity igte = mte.getBaseMetaTileEntity();
        if (igte == null) {
            return null;
        }
        Vector4i key = (Vector4i)this.pooler.getInstance();
        key.w = igte.getWorld().field_73011_w.field_76574_g;
        key.x = igte.getXCoord();
        key.y = igte.getYCoord();
        key.z = igte.getZCoord();
        Object removed = this.remove(key);
        this.pooler.releaseInstance((Object)key);
        return (T)removed;
    }

    public T computeIfAbsent(World world, int x, int y, int z, Function<Vector4i, T> ctor) {
        Vector4i key = (Vector4i)this.pooler.getInstance();
        key.w = world.field_73011_w.field_76574_g;
        key.x = x;
        key.y = y;
        key.z = z;
        T t = this.computeIfAbsent(key, ctor);
        this.pooler.releaseInstance((Object)key);
        return t;
    }
}

