/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.client.GUI.GGUITextures;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.tooltip.TooltipHelper;
import gregtech.common.misc.GTStructureChannels;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class MTEPreciseAssembler
extends MTEExtendedPowerMultiBlockBase<MTEPreciseAssembler>
implements IConstructable,
ISurvivalConstructable {
    private static final IIconContainer textureFontOn = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK");
    private static final IIconContainer textureFontOn_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QTANK_GLOW");
    private static final IIconContainer textureFontOff = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST");
    private static final IIconContainer textureFontOff_Glow = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_QCHEST_GLOW");
    protected IStructureDefinition<MTEPreciseAssembler> multiDefinition = null;
    protected int casingAmount;
    protected int casingTier;
    protected int machineTier;
    protected int mode;
    protected int energyHatchTier;
    private static final int CASING_INDEX = 1541;
    private int glassTier = -1;

    public MTEPreciseAssembler(String name) {
        super(name);
    }

    public MTEPreciseAssembler(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    @Override
    public IStructureDefinition<MTEPreciseAssembler> getStructureDefinition() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"F       F", "CGGGGGGGC", "C-------C", "CGGGGGGGC", "F       F"}, {"CCCC~CCCC", "CMMMMMMMC", "CMMMMMMMC", "CMMMMMMMC", "CCCCCCCCC"}})).addElement('C', GTStructureChannels.PRASS_UNIT_CASING.use(GTStructureUtility.buildHatchAdder(MTEPreciseAssembler.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Muffler, HatchElement.ExoticEnergy.or(HatchElement.Energy)).casingIndex(1541).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlocksTiered(MTEPreciseAssembler::getCasingBlockTier, (List)ImmutableList.of((Object)Pair.of((Object)Loaders.impreciseUnitCasing, (Object)0), (Object)Pair.of((Object)Loaders.preciseUnitCasing, (Object)0), (Object)Pair.of((Object)Loaders.preciseUnitCasing, (Object)1), (Object)Pair.of((Object)Loaders.preciseUnitCasing, (Object)2), (Object)Pair.of((Object)Loaders.preciseUnitCasing, (Object)3)), (Object)-3, MTEPreciseAssembler::setCasingTier, MTEPreciseAssembler::getCasingTier))))).addElement('F', GTStructureUtility.ofFrame(Materials.TungstenSteel)).addElement('G', GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
                te.glassTier = t;
            }, te -> te.glassTier)).addElement('M', GTStructureChannels.TIER_MACHINE_CASING.use(StructureUtility.ofBlocksTiered((block, meta) -> block == GregTechAPI.sBlockCasings1 && meta >= 0 && meta <= 9 ? Integer.valueOf(meta) : null, IntStream.range(0, 10).mapToObj(meta -> Pair.of((Object)GregTechAPI.sBlockCasings1, (Object)meta)).collect(Collectors.toList()), (Object)-1, MTEPreciseAssembler::setMachineTier, MTEPreciseAssembler::getMachineTier))).build();
        }
        return this.multiDefinition;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.casingTier = aNBT.func_74762_e("casingTier");
        this.machineTier = aNBT.func_74762_e("machineTier");
        this.mode = aNBT.func_74762_e("RunningMode");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("casingTier", this.casingTier);
        aNBT.func_74768_a("machineTier", this.machineTier);
        aNBT.func_74768_a("RunningMode", this.mode);
        super.saveNBTData(aNBT);
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.mode = (this.mode + 1) % 2;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)("preciseassembler.chat." + this.mode)));
        }
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                if (MTEPreciseAssembler.this.mode == 0 && recipe.mSpecialValue > MTEPreciseAssembler.this.casingTier + 1) {
                    return CheckRecipeResultRegistry.insufficientMachineTier(recipe.mSpecialValue);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setDurationModifier(MTEPreciseAssembler.this.mode == 0 ? 1.0 : 0.5);
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.mode == 0 ? 1 : (int)GTUtility.powInt(2.0, 4 + (this.casingTier + 1));
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        boolean useSingleAmp = this.mEnergyHatches.size() == 1 && this.mExoticEnergyHatches.isEmpty();
        logic.setAvailableVoltage(this.getMachineVoltageLimit());
        logic.setAvailableAmperage(useSingleAmp ? 1L : this.getMaxInputAmps());
        logic.setAmperageOC(true);
        logic.setMaxTierSkips(0);
    }

    public long getMachineVoltageLimit() {
        if (this.machineTier < 0) {
            return 0L;
        }
        if (this.machineTier >= 9) {
            return GTValues.V[this.energyHatchTier];
        }
        return GTValues.V[Math.min(this.machineTier, this.energyHatchTier)];
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        if (this.mode == 0) {
            return GoodGeneratorRecipeMaps.preciseAssemblerRecipes;
        }
        return RecipeMaps.assemblerRecipes;
    }

    @Override
    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(GoodGeneratorRecipeMaps.preciseAssemblerRecipes, RecipeMaps.assemblerRecipes);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 4, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 4, 4, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.machineTier = -1;
        this.casingAmount = 0;
        this.casingTier = -3;
        this.glassTier = -1;
        this.energyHatchTier = 0;
        if (this.checkPiece(this.mName, 4, 4, 0)) {
            this.energyHatchTier = this.checkEnergyHatchTier();
            if (this.casingTier >= -1) {
                this.reUpdate(1541 + this.casingTier);
            }
            this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
            return this.casingAmount >= 42 && this.mMaintenanceHatches.size() == 1 && this.glassTier >= 4 && !this.mMufflerHatches.isEmpty();
        }
        return false;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Precise Assembler, Assembler, PrAss").addInfo("No more than 7nm of error").addInfo("Has Two Modes: Precise and Normal").addInfo("Use a Screwdriver to change modes").addSeparator().addInfo("Precise Mode unlocks the ability to assemble precise components").addInfo("Casing Tier determines Maximum Recipe Tier").addSeparator().addInfo("Normal Mode allows standard assembler recipes").addInfo(EnumChatFormatting.WHITE + "Precise Casing" + EnumChatFormatting.GRAY + " Tier determines " + TooltipHelper.parallelText("Parallels")).addInfo(this.tieredTextLine("Imprecise", "Mk-I", "MK-II", "MK-III", "MK-IV") + "->" + this.tieredTextLine("16", "32", "64", "128", "256") + " Parallels").addStaticSpeedInfo(2.0f).addSeparator().addInfo("Machine Casing limits the voltage tier the machine can work on, " + GTValues.TIER_COLORS[9] + "UHV" + EnumChatFormatting.GRAY + "-tier Machine Casing unlocks all.").addTecTechHatchInfo().addNoTierSkips().addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(9, 5, 5, true).addController("Front bottom").addCasingInfoExactly("Machine Casing", 21, true).addCasingInfoExactly("Any Tiered Glass (EV+)", 42, false).addCasingInfoRange("Precise Electronic Unit Casing", 42, 86, true).addInputHatch("Any Casing").addInputBus("Any Casing").addOutputHatch("Any Casing").addOutputBus("Any Casing").addEnergyHatch("Any Casing").addMufflerHatch("Any Casing").addMaintenanceHatch("Any Casing").addSubChannelUsage(GTStructureChannels.BOROGLASS).addSubChannelUsage(GTStructureChannels.PRASS_UNIT_CASING).addSubChannelUsage(GTStructureChannels.TIER_MACHINE_CASING).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 780;
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("PreciseAssembler.hint", 7);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPreciseAssembler(this.mName);
    }

    private int checkEnergyHatchTier() {
        int tier = 0;
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            tier = Math.max(tHatch.mTier, tier);
        }
        for (MTEHatch tHatch : GTUtility.validMTEList(this.mExoticEnergyHatches)) {
            tier = Math.max(tHatch.mTier, tier);
        }
        return tier;
    }

    public int getCasingTier() {
        return this.casingTier;
    }

    public void setCasingTier(int i) {
        this.casingTier = i;
    }

    public int getMachineTier() {
        return this.machineTier;
    }

    public void setMachineTier(int i) {
        this.machineTier = i;
    }

    @Nullable
    public static Integer getCasingBlockTier(Block block, int meta) {
        if (block == Loaders.impreciseUnitCasing) {
            return -1;
        }
        if (block == Loaders.preciseUnitCasing) {
            return meta;
        }
        return null;
    }

    public void reUpdate(int texture) {
        for (Object hatch : this.mDualInputHatches) {
            if (!((MetaTileEntity)hatch).isValid()) continue;
            hatch.updateTexture(texture);
        }
        for (Object hatch : GTUtility.validMTEList(this.mInputHatches)) {
            ((MTEHatch)hatch).updateTexture(texture);
        }
        for (Object hatch : GTUtility.validMTEList(this.mInputBusses)) {
            ((MTEHatch)hatch).updateTexture(texture);
        }
        for (Object hatch : GTUtility.validMTEList(this.mOutputHatches)) {
            ((MTEHatch)hatch).updateTexture(texture);
        }
        for (Object hatch : GTUtility.validMTEList(this.mOutputBusses)) {
            ((MTEHatch)hatch).updateTexture(texture);
        }
        for (Object hatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            ((MTEHatch)hatch).updateTexture(texture);
        }
        for (Object hatch : GTUtility.validMTEList(this.mMaintenanceHatches)) {
            ((MTEHatch)hatch).updateTexture(texture);
        }
        for (Object hatch : GTUtility.validMTEList(this.mMufflerHatches)) {
            ((MTEHatch)hatch).updateTexture(texture);
        }
        for (Object hatch : GTUtility.validMTEList(this.mExoticEnergyHatches)) {
            ((MTEHatch)hatch).updateTexture(texture);
        }
    }

    @Override
    public byte getUpdateData() {
        return (byte)this.casingTier;
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (aEventID == 1 && ((aValue & 0x80) == 0 || aValue == -1)) {
            this.casingTier = aValue;
        }
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        int t = Math.max(this.getCasingTier(), -1);
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1541 + t), TextureFactory.builder().addIcon(textureFontOn).extFacing().build(), TextureFactory.builder().addIcon(textureFontOn_Glow).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1541 + t), TextureFactory.builder().addIcon(textureFontOff).extFacing().build(), TextureFactory.builder().addIcon(textureFontOff_Glow).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1541 + t)};
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget(new CycleButtonWidget().setToggle(() -> this.mode == 1, val -> {
            this.mode = val != false ? 1 : 0;
        }).setTextureGetter(state -> state == 1 ? GGUITextures.OVERLAY_BUTTON_ASSEMBLER_MODE : GGUITextures.OVERLAY_BUTTON_PRECISE_MODE).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setPos(80, 91).setSize(16, 16).dynamicTooltip(() -> Collections.singletonList(StatCollector.func_74838_a((String)("preciseassembler.chat." + this.mode)))).setUpdateTooltipEveryTick(true).setTooltipShowUpDelay(5));
    }

    @Override
    public boolean isInputSeparationEnabled() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74778_a("mode", this.getMachineModeName());
    }

    @Override
    public String getMachineModeName() {
        return StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_PRECISE_ASSEMBLER.mode." + this.mode));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_MULTI_PRECISE_LOOP;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        ((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> this.machineTier > 0 && this.machineTier < 9 ? StatCollector.func_74837_a((String)"GT5U.multiblock.preciseassemblercasing", (Object[])new Object[]{GTUtility.getColoredTierNameFromVoltage(GTValues.V[this.machineTier])}) : "").setTextAlignment(Alignment.CenterLeft).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(ignored -> this.machineTier > 0 && this.machineTier < 9))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.machineTier, tier -> {
            this.machineTier = tier;
        }));
        super.drawTexts(screenElements, inventorySlot);
    }

    private String tieredTextLine(String mk0, String mk1, String mk2, String mk3, String mk4) {
        return EnumChatFormatting.GREEN + mk0 + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.BLUE + mk1 + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.LIGHT_PURPLE + mk2 + EnumChatFormatting.GRAY + "/" + EnumChatFormatting.GOLD + mk3 + EnumChatFormatting.LIGHT_PURPLE + "/" + EnumChatFormatting.RED + mk4 + EnumChatFormatting.GRAY;
    }
}

