/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.splitbutton;

import com.github.weisj.darklaf.components.button.JSplitButton;
import com.github.weisj.darklaf.ui.button.ButtonConstants;
import com.github.weisj.darklaf.ui.button.DarkButtonBorder;
import com.github.weisj.darklaf.ui.splitbutton.DarkSplitButtonUI;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;

public class DarkSplitButtonBorder
extends DarkButtonBorder {
    @Override
    protected void paintBorderlessBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.showSplit(c)) {
            this.paintDivider(c, g, x, y, width, height);
        }
        super.paintBorderlessBorder(c, g, x, y, width, height);
    }

    @Override
    protected void paintLineBorder(Component c, Graphics2D g2, int arc, boolean focus, int bx, int by, int bw, int bh) {
        if (this.showSplit(c)) {
            this.paintDivider(c, g2, bx, by, bw, bh);
        }
        super.paintLineBorder(c, g2, arc, focus, bx, by, bw, bh);
    }

    protected void paintDivider(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JSplitButton)) {
            return;
        }
        Component arrowButton = ((JSplitButton)c).getComponent(0);
        if (arrowButton == null) {
            return;
        }
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        int splitPos = ltr ? arrowButton.getX() : arrowButton.getX() + arrowButton.getWidth() - 1;
        DarkSplitButtonUI ui = DarkUIUtil.getUIOfType(((JSplitButton)c).getUI(), DarkSplitButtonUI.class);
        if (ui != null && ui.getDrawOutline(c)) {
            boolean armed = ui.isArmedBorderless(ui.splitButton);
            g.setColor(ui.getBorderlessOutline(armed));
        } else {
            g.setColor(this.getBorderColor(c, false));
        }
        g.fillRect(splitPos, y, 1, height);
    }

    protected boolean showSplit(Component c) {
        boolean hasDefaultAction = c instanceof JSplitButton && ((JSplitButton)c).getActionCount() > 1;
        boolean borderless = ButtonConstants.isBorderlessVariant(c);
        if (!borderless) {
            return hasDefaultAction;
        }
        if (hasDefaultAction && ButtonConstants.isBorderlessVariant(c)) {
            DarkSplitButtonUI ui = DarkUIUtil.getUIOfType(((JSplitButton)c).getUI(), DarkSplitButtonUI.class);
            return ui != null && (ui.isRolloverBorderless((AbstractButton)c) || ui.isArmedBorderless((AbstractButton)c));
        }
        return false;
    }
}

