/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.popupmenu;

import com.github.weisj.darklaf.ui.DarkPopupFactory;
import com.github.weisj.darklaf.ui.popupmenu.EventHelperUtil;
import com.github.weisj.darklaf.ui.popupmenu.MouseGrabberUtil;
import com.github.weisj.darklaf.ui.popupmenu.PopupMenuContainer;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.ui.util.OneTimeExecutionLock;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class DarkPopupMenuUI
extends BasicPopupMenuUI {
    public static final String KEY_DO_NOT_CANCEL_POPUP = "doNotCancelPopup";
    public static final String KEY_CONSUME_EVENT_ON_CLOSE = "consumeEventOnClose";
    public static final String KEY_DO_NOT_CANCEL_ON_SCROLL = "doNotCancelOnScroll";
    public static final String HIDE_POPUP_VALUE = "doNotCancelPopup";
    public static final String KEY_DEFAULT_LIGHTWEIGHT_POPUPS = "PopupMenu.defaultLightWeightPopups";
    public static final String KEY_MAX_POPUP_SIZE = "maxPopupSize";
    final OneTimeExecutionLock sizeLock = new OneTimeExecutionLock();
    private PopupMenuContainer popupMenuContainer;

    public static ComponentUI createUI(JComponent x) {
        return new DarkPopupMenuUI();
    }

    public DarkPopupMenuUI() {
        EventHelperUtil.installEventHelper();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Window window = SwingUtilities.getWindowAncestor(c);
        if (window != null && window.getOpacity() != 1.0f) {
            window.setOpacity(1.0f);
        }
        super.paint(g, c);
    }

    public static List<JPopupMenu> getPopups() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] p = msm.getSelectedPath();
        ArrayList<JPopupMenu> list = new ArrayList<JPopupMenu>(p.length);
        for (MenuElement element : p) {
            if (!(element instanceof JPopupMenu)) continue;
            list.add((JPopupMenu)element);
        }
        return list;
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.popupMenu.putClientProperty("JPopupFactory.startHidden", true);
    }

    private PopupMenuContainer getPopupMenuContainer() {
        if (this.popupMenuContainer == null) {
            this.popupMenuContainer = new PopupMenuContainer();
        }
        return this.popupMenuContainer;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        MouseGrabberUtil.installMouseGrabber();
    }

    private Dimension getConstraintSizes(JComponent popup, Point pos) {
        Dimension maxSize = PropertyUtil.getObject(popup, KEY_MAX_POPUP_SIZE, Dimension.class);
        if (maxSize == null) {
            maxSize = new Dimension(-1, -1);
        }
        if (pos != null && (maxSize.height <= 0 || maxSize.width <= 0)) {
            Rectangle screenSize = DarkUIUtil.getScreenBounds(popup, pos.x, pos.y, false);
            if (maxSize.height <= 0) {
                maxSize.height = screenSize.height;
            }
            if (maxSize.width <= 0) {
                maxSize.width = screenSize.width;
            }
        }
        return maxSize;
    }

    @Override
    public Popup getPopup(JPopupMenu popup, int x, int y) {
        if (popup.getComponentCount() == 0) {
            return DarkPopupFactory.createNoOpPopup();
        }
        PopupMenuContainer container = this.getPopupMenuContainer();
        if (container == null) {
            return super.getPopup(popup, x, y);
        }
        Dimension constraintSize = this.getConstraintSizes(popup, new Point(x, y));
        try (OneTimeExecutionLock l = this.sizeLock.lock();){
            Dimension prefSize = popup.getPreferredSize();
            Popup popup2 = container.createPopup(popup, prefSize, x, y, constraintSize.width, constraintSize.height);
            return popup2;
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.sizeLock.isLocked()) {
            return null;
        }
        try (OneTimeExecutionLock l = this.sizeLock.lock();){
            Dimension prefSize = c.getPreferredSize();
            Dimension constraintSize = this.getConstraintSizes(c, null);
            Dimension dimension = this.getPopupMenuContainer().adjustSize(prefSize, constraintSize.width, constraintSize.height);
            return dimension;
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (this.sizeLock.isLocked()) {
            return null;
        }
        try (OneTimeExecutionLock l = this.sizeLock.lock();){
            Dimension prefSize = c.getMinimumSize();
            Dimension constraintSize = this.getConstraintSizes(c, null);
            Dimension dimension = this.getPopupMenuContainer().adjustSize(prefSize, constraintSize.width, constraintSize.height);
            return dimension;
        }
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (this.sizeLock.isLocked()) {
            return null;
        }
        try (OneTimeExecutionLock l = this.sizeLock.lock();){
            Dimension prefSize = c.getMaximumSize();
            Dimension constraintSize = this.getConstraintSizes(c, null);
            Dimension dimension = this.getPopupMenuContainer().adjustSize(prefSize, constraintSize.width, constraintSize.height);
            return dimension;
        }
    }
}

