/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.cell;

import com.github.weisj.darklaf.ui.cell.ComponentBasedTableCellRenderer;
import com.github.weisj.darklaf.ui.cell.ComponentBasedTreeCellRenderer;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererCheckBox;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererRadioButton;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererToggleButton;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class DarkBooleanCellRenderer
implements TableCellRenderer,
TreeCellRenderer {
    private final DarkCellRendererCheckBox checkBoxRenderer;
    private final DarkCellRendererRadioButton radioRenderer;

    public DarkBooleanCellRenderer(boolean opaque) {
        this.checkBoxRenderer = new DarkCellRendererCheckBox(opaque);
        this.radioRenderer = new DarkCellRendererRadioButton(opaque);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getBooleanRenderer(table).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return this.getBooleanRenderer(tree).getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    protected ComponentBasedTableCellRenderer getBooleanRenderer(JTable table) {
        return this.getRenderer(PropertyUtil.isPropertyEqual(table, "JTable.booleanRenderType", "radioButton"));
    }

    protected ComponentBasedTreeCellRenderer getBooleanRenderer(JTree tree) {
        return this.getRenderer(PropertyUtil.isPropertyEqual(tree, "JTree.booleanRenderType", "radioButton"));
    }

    private DarkCellRendererToggleButton<?> getRenderer(boolean useRadioButton) {
        return useRadioButton ? this.radioRenderer : this.checkBoxRenderer;
    }

    public JComponent getRendererComponent(JTree tree) {
        return this.getBooleanRenderer(tree).getRendererComponent();
    }

    public JComponent getRendererComponent(JTable table) {
        return this.getBooleanRenderer(table).getRendererComponent();
    }
}

