/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.parser;

import com.github.weisj.darklaf.properties.icons.EmptyIcon;
import com.github.weisj.darklaf.properties.icons.StateIcon;
import com.github.weisj.darklaf.properties.icons.UIAwareIcon;
import com.github.weisj.darklaf.properties.parser.Delimiters;
import com.github.weisj.darklaf.properties.parser.KeyFilteredParser;
import com.github.weisj.darklaf.properties.parser.ParseResult;
import com.github.weisj.darklaf.properties.parser.ParserContext;
import com.github.weisj.darklaf.properties.parser.ParserUtil;
import com.github.weisj.darklaf.properties.parser.PropertyParser;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class IconParser
extends KeyFilteredParser
implements Delimiters {
    private static final char MODIFIER_START = '[';
    private static final char MODIFIER_END = ']';
    private static final char MODIFIER_DELIMITER = ',';
    private static final String DUAL_KEY = "dual";
    private static final String AWARE_KEY = "aware";
    private static final String THEMED_KEY = "themed";
    private static final String ICON_EMPTY = "empty";

    public IconParser() {
        super(".icon", "Icon", "Image");
    }

    @Override
    public ParseResult doParse(ParseResult parseResult, ParserContext context) {
        Icon icon;
        if (parseResult.value.startsWith(String.valueOf('[')) && parseResult.value.endsWith(String.valueOf(']'))) {
            return IconParser.parseStateIcon(parseResult, context);
        }
        Dimension dim = new Dimension(-1, -1);
        if (parseResult.value.endsWith(String.valueOf(')'))) {
            List<Integer> dimensions = ParserUtil.parseDelimited('(', ')', ',', false, PropertyParser.of(Integer::parseInt), Integer.class, parseResult, context);
            if (dimensions.size() != 2) {
                return ParserUtil.error(parseResult, "Invalid dimension.");
            }
            dim.width = dimensions.get(0);
            dim.height = dimensions.get(1);
        }
        List<Object> modifiers = parseResult.value.endsWith(String.valueOf(']')) ? ParserUtil.parseDelimited('[', ']', ',', false, PropertyParser.of(s -> s), String.class, parseResult, context) : Collections.emptyList();
        boolean dual = modifiers.contains(DUAL_KEY);
        boolean aware = modifiers.contains(AWARE_KEY);
        boolean themed = modifiers.contains(THEMED_KEY);
        if (aware && themed) {
            return ParserUtil.error(parseResult, "Modifiers aware and themed are mutually exclusive.");
        }
        if (ICON_EMPTY.equals(parseResult.value)) {
            icon = EmptyIcon.create(dim.width, dim.height);
        } else if (themed) {
            icon = context.iconResolver.getIcon(parseResult.value, dim.width, dim.height, true);
        } else if (dual || aware) {
            UIAwareIcon awareIcon = context.iconResolver.getUIAwareIcon(parseResult.value, dim.width, dim.height);
            icon = dual ? awareIcon.getDual() : awareIcon;
        } else {
            icon = context.iconResolver.getIcon(parseResult.value, dim.width, dim.height);
        }
        return ParserUtil.setNonNull(parseResult, icon);
    }

    private static ParseResult parseStateIcon(ParseResult parseResult, ParserContext context) {
        return ParserUtil.setNonNull(parseResult, new StateIcon(ParserUtil.parseDelimited('[', ']', ',', Icon.class, parseResult, context)));
    }
}

