/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import binnie.core.IInitializable;
import binnie.core.Mods;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.config.EBConfig;
import binnie.extrabees.genetics.ExtraBeeDefinition;
import binnie.extrabees.worldgen.BlockExtraBeeHive;
import binnie.extrabees.worldgen.EnumHiveType;
import binnie.extrabees.worldgen.HiveDrop;
import binnie.extrabees.worldgen.ItemBeehive;
import binnie.extrabees.worldgen.MaterialBeehive;
import binnie.extrabees.worldgen.WorldGenHiveNether;
import binnie.extrabees.worldgen.WorldGenHiveRock;
import binnie.extrabees.worldgen.WorldGenHiveWater;
import buildcraft.api.core.BuildCraftAPI;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.apiculture.genetics.BeeDefinition;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class ModuleGeneration
implements IWorldGenerator,
IInitializable {
    @Override
    public void preInit() {
        ExtraBees.materialBeehive = new MaterialBeehive();
        ExtraBees.hive = new BlockExtraBeeHive();
        GameRegistry.registerBlock((Block)ExtraBees.hive, ItemBeehive.class, (String)"hive");
    }

    @Override
    public void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ModuleGeneration(), (int)0);
        if (!EBConfig.canQuarryMineHives && Mods.buildcraftCore.active()) {
            BuildCraftAPI.softBlocks.add(ExtraBees.hive);
        }
    }

    @Override
    public void postInit() {
        EnumHiveType.WATER.drops.add(new HiveDrop(ExtraBeeDefinition.WATER.getGenome().getPrimary(), 80));
        EnumHiveType.WATER.drops.add(new HiveDrop(BeeDefinition.VALIANT.getGenome().getPrimary(), 3));
        EnumHiveType.ROCK.drops.add(new HiveDrop(ExtraBeeDefinition.ROCK.getGenome().getPrimary(), 80));
        EnumHiveType.ROCK.drops.add(new HiveDrop(BeeDefinition.VALIANT.getGenome().getPrimary(), 3));
        EnumHiveType.NETHER.drops.add(new HiveDrop(ExtraBeeDefinition.BASALT.getGenome().getPrimary(), 80));
        EnumHiveType.NETHER.drops.add(new HiveDrop(BeeDefinition.VALIANT.getGenome().getPrimary(), 3));
        ExtraBees.hive.setHarvestLevel("scoop", 0, 0);
        ExtraBees.hive.setHarvestLevel("scoop", 0, 1);
        ExtraBees.hive.setHarvestLevel("scoop", 0, 2);
        ExtraBees.hive.setHarvestLevel("scoop", 0, 3);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int i;
        chunkX <<= 4;
        chunkZ <<= 4;
        for (i = 0; i < EBConfig.waterHiveRate; ++i) {
            randPosX = chunkX + rand.nextInt(16);
            randPosY = rand.nextInt(50) + 20;
            randPosZ = chunkZ + rand.nextInt(16);
            new WorldGenHiveWater().func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (i = 0; i < EBConfig.rockHiveRate; ++i) {
            randPosX = chunkX + rand.nextInt(16);
            randPosY = rand.nextInt(50) + 20;
            randPosZ = chunkZ + rand.nextInt(16);
            new WorldGenHiveRock().func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (i = 0; i < EBConfig.netherHiveRate; ++i) {
            randPosX = chunkX + rand.nextInt(16);
            randPosY = rand.nextInt(50) + 20;
            randPosZ = chunkZ + rand.nextInt(16);
            new WorldGenHiveNether().func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
    }
}

