/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import org.joml.Vector3i;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;

public class Camera {
    private final Vector3f pos;
    private final Vector3f lookAt;

    public Camera(Vector3f pos, Vector3f lookAt) {
        this.pos = pos;
        this.lookAt = lookAt;
    }

    public Camera setLookAt(Vector3f pos, Vector3f lookAt) {
        this.pos.set((ReadableVector3f)pos);
        this.lookAt.set((ReadableVector3f)lookAt);
        return this;
    }

    public Camera setLookAt(float x, float y, float z) {
        this.lookAt.set(x, y, z);
        return this;
    }

    public Camera setPos(float x, float y, float z) {
        this.lookAt.set(x, y, z);
        return this;
    }

    public Camera setLookAt(Vector3f lookAt, double radius, double yaw, double pitch) {
        return this.setLookAt(lookAt.x, lookAt.y, lookAt.z, radius, yaw, pitch);
    }

    public Camera setLookAt(Vector3i lookAt, double radius, double yaw, double pitch) {
        return this.setLookAt(lookAt.x, lookAt.y, lookAt.z, radius, yaw, pitch);
    }

    public Camera setLookAt(float lookAtX, float lookAtY, float lookAtZ, double radius, double yaw, double pitch) {
        this.setLookAt(lookAtX, lookAtY, lookAtZ);
        Vector3f pos = new Vector3f((float)Math.cos(yaw), 0.0f, (float)Math.sin(yaw));
        pos.y += (float)(Math.tan(pitch) * (double)pos.length());
        pos.normalise().scale((float)radius);
        this.pos.set((ReadableVector3f)pos.translate(lookAtX, lookAtY, lookAtZ));
        return this;
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public Vector3f getLookAt() {
        return this.lookAt;
    }
}

