/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.google.common.base.Preconditions;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockInfo {
    public static final BlockInfo EMPTY = new BlockInfo(Blocks.field_150350_a);
    public static final BlockInfo INVALID = new BlockInfo(Blocks.field_150350_a);
    private Block block;
    private int blockMeta;
    private TileEntity tileEntity;

    public static BlockInfo of(IBlockAccess world, BlockPos pos) {
        Block block = world.func_147439_a(pos.x, pos.y, pos.z);
        int blockMeta = world.func_72805_g(pos.x, pos.y, pos.z);
        if (block.isAir(world, pos.x, pos.y, pos.z)) {
            return EMPTY;
        }
        TileEntity tile = null;
        if (block.hasTileEntity(blockMeta)) {
            tile = world.func_147438_o(pos.x, pos.y, pos.z);
        }
        return new BlockInfo(block, blockMeta, tile);
    }

    public BlockInfo(@NotNull Block block) {
        this(block, 0, null);
    }

    public BlockInfo(@NotNull Block block, int blockMeta) {
        this(block, blockMeta, null);
    }

    public BlockInfo(@NotNull Block block, @Nullable TileEntity tileEntity) {
        this(block, 0, tileEntity);
    }

    public BlockInfo(@NotNull Block block, int blockMeta, @Nullable TileEntity tileEntity) {
        this.set(block, blockMeta, tileEntity);
    }

    public Block getBlock() {
        return this.block;
    }

    public int getBlockMeta() {
        return this.blockMeta;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public void apply(World world, BlockPos pos) {
        world.func_147449_b(pos.x, pos.y, pos.z, this.block);
        world.func_72921_c(pos.x, pos.y, pos.z, this.blockMeta, 2);
        if (this.tileEntity != null) {
            world.func_147455_a(pos.x, pos.y, pos.z, this.tileEntity);
        } else {
            this.tileEntity = world.func_147438_o(pos.x, pos.y, pos.z);
        }
    }

    BlockInfo set(Block block, int blockMeta, TileEntity tile) {
        Preconditions.checkNotNull((Object)block, (Object)"Block must not be null!");
        Preconditions.checkArgument((tile == null || block.hasTileEntity(blockMeta) ? 1 : 0) != 0, (Object)"Cannot create block info with tile entity for block not having it!");
        this.block = block;
        this.blockMeta = blockMeta;
        this.tileEntity = tile;
        return this;
    }

    public boolean isMutable() {
        return false;
    }

    public Mut toMutable() {
        return new Mut(this.block, this.blockMeta, this.tileEntity);
    }

    public BlockInfo toImmutable() {
        return this;
    }

    public BlockInfo copy() {
        return new BlockInfo(this.block, this.blockMeta, this.tileEntity);
    }

    public static class Mut
    extends BlockInfo {
        public static final Mut SHARED = new Mut();

        public Mut() {
            this(Blocks.field_150350_a);
        }

        public Mut(@NotNull Block block) {
            super(block);
        }

        public Mut(@NotNull Block block, int blockMeta) {
            super(block, blockMeta);
        }

        public Mut(@NotNull Block block, @Nullable TileEntity tileEntity) {
            super(block, tileEntity);
        }

        public Mut(@NotNull Block block, int blockMeta, @Nullable TileEntity tileEntity) {
            super(block, blockMeta, tileEntity);
        }

        @Override
        public Mut set(Block block, int blockMeta, TileEntity tile) {
            return (Mut)super.set(block, blockMeta, tile);
        }

        public Mut set(IBlockAccess world, BlockPos pos) {
            Block block = world.func_147439_a(pos.x, pos.y, pos.z);
            int blockMeta = world.func_72805_g(pos.x, pos.y, pos.z);
            TileEntity tile = null;
            if (block.hasTileEntity(blockMeta)) {
                tile = world.func_147438_o(pos.x, pos.y, pos.z);
            }
            return this.set(block, blockMeta, tile);
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public Mut toMutable() {
            return this;
        }

        @Override
        public BlockInfo toImmutable() {
            return new BlockInfo(this.getBlock(), this.getBlockMeta(), this.getTileEntity());
        }

        @Override
        public Mut copy() {
            return new Mut(this.getBlock(), this.getBlockMeta(), this.getTileEntity());
        }
    }
}

