/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.screen;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.inventory.ClickType;
import com.cleanroommc.modularui.factory.GuiData;
import com.cleanroommc.modularui.mixins.early.minecraft.ContainerAccessor;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.NEAAnimationHandler;
import com.cleanroommc.modularui.screen.UISettings;
import com.cleanroommc.modularui.utils.Platform;
import com.cleanroommc.modularui.utils.item.ItemHandlerHelper;
import com.cleanroommc.modularui.value.sync.ModularSyncManager;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.widgets.slot.ModularSlot;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularContainer
extends Container {
    private static final int DROP_TO_WORLD = -999;
    private static final int LEFT_MOUSE = 0;
    private static final int RIGHT_MOUSE = 1;
    private EntityPlayer player;
    private ModularSyncManager syncManager;
    private boolean init = true;
    private final List<ModularSlot> phantomSlots = new ArrayList<ModularSlot>();
    private final List<ModularSlot> shiftClickSlots = new ArrayList<ModularSlot>();
    private GuiData guiData;
    private UISettings settings;
    @SideOnly(value=Side.CLIENT)
    private ModularScreen optionalScreen;

    public static ModularContainer getCurrent(EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof ModularContainer) {
            ModularContainer container2 = (ModularContainer)container;
            return container2;
        }
        return null;
    }

    @ApiStatus.Internal
    public void construct(EntityPlayer player, PanelSyncManager panelSyncManager, UISettings settings, String mainPanelName, GuiData guiData) {
        this.player = player;
        this.syncManager = new ModularSyncManager(this);
        this.syncManager.construct(mainPanelName, panelSyncManager);
        this.settings = settings;
        this.guiData = guiData;
        this.sortShiftClickSlots();
    }

    @SideOnly(value=Side.CLIENT)
    void initializeClient(ModularScreen screen) {
        this.optionalScreen = screen;
    }

    @SideOnly(value=Side.CLIENT)
    @ApiStatus.Internal
    public void constructClientOnly() {
        this.player = Platform.getClientPlayer();
        this.syncManager = null;
    }

    public boolean isInitialized() {
        return this.player != null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModularScreen getScreen() {
        if (this.optionalScreen == null) {
            throw new NullPointerException("ModularScreen is not yet initialised!");
        }
        return this.optionalScreen;
    }

    public ContainerAccessor acc() {
        return (ContainerAccessor)((Object)this);
    }

    public void func_75132_a(ICrafting player) {
        super.func_75132_a(player);
        if (this.syncManager != null) {
            this.syncManager.onOpen();
        }
    }

    public void func_75134_a(@NotNull EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (this.syncManager != null) {
            this.syncManager.onClose();
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.syncManager != null) {
            this.syncManager.detectAndSendChanges(this.init);
        }
        this.init = false;
    }

    private void sortShiftClickSlots() {
        this.shiftClickSlots.sort(Comparator.comparingInt(slot -> Objects.requireNonNull(slot.getSlotGroup()).getShiftClickPriority()));
    }

    public void func_75131_a(ItemStack[] items) {
        if (this.field_75151_b.size() != items.length) {
            ModularUI.LOGGER.error("Here are {} slots, but expected {}", new Object[]{this.field_75151_b.size(), items.length});
        }
        for (int i = 0; i < Math.min(this.field_75151_b.size(), items.length); ++i) {
            this.func_75139_a(i).func_75215_d(items[i]);
        }
    }

    @ApiStatus.Internal
    public void registerSlot(String panelName, ModularSlot slot) {
        SlotGroup slotGroup;
        if (slot.isPhantom()) {
            if (this.phantomSlots.contains((Object)slot)) {
                throw new IllegalArgumentException("Tried to register slot which already exists!");
            }
            this.phantomSlots.add(slot);
        } else {
            if (this.field_75151_b.contains((Object)slot)) {
                throw new IllegalArgumentException("Tried to register slot which already exists!");
            }
            this.func_75146_a(slot);
        }
        if (slot.getSlotGroupName() != null) {
            slotGroup = this.getSyncManager().getSlotGroup(panelName, slot.getSlotGroupName());
            if (slotGroup == null) {
                ModularUI.LOGGER.throwing((Throwable)new IllegalArgumentException("SlotGroup '" + slot.getSlotGroupName() + "' is not registered!"));
                return;
            }
            slot.slotGroup(slotGroup);
        }
        if (slot.getSlotGroup() != null && (slotGroup = slot.getSlotGroup()).allowShiftTransfer()) {
            this.shiftClickSlots.add(slot);
            if (!this.init) {
                this.sortShiftClickSlots();
            }
        }
    }

    @Contract(value="_, null, null -> fail")
    @NotNull
    @ApiStatus.Internal
    public SlotGroup validateSlotGroup(String panelName, @Nullable String slotGroupName, @Nullable SlotGroup slotGroup) {
        if (slotGroup != null) {
            if (this.getSyncManager().getSlotGroup(panelName, slotGroup.getName()) == null) {
                throw new IllegalArgumentException("Slot group is not registered in the GUI.");
            }
            return slotGroup;
        }
        if (slotGroupName != null) {
            slotGroup = this.getSyncManager().getSlotGroup(panelName, slotGroupName);
            if (slotGroup == null) {
                throw new IllegalArgumentException("Can't find slot group for name " + slotGroupName);
            }
            return slotGroup;
        }
        throw new IllegalArgumentException("Either the slot group or the name must not be null!");
    }

    public ModularSyncManager getSyncManager() {
        if (this.syncManager == null) {
            throw new IllegalStateException("GuiSyncManager is not available for client only GUI's.");
        }
        return this.syncManager;
    }

    public boolean isClient() {
        return this.syncManager == null || NetworkUtils.isClient(this.player);
    }

    public boolean isClientOnly() {
        return this.syncManager == null;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public GuiData getGuiData() {
        return this.guiData;
    }

    public ModularSlot getModularSlot(int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot instanceof ModularSlot) {
            ModularSlot modularSlot = (ModularSlot)slot;
            return modularSlot;
        }
        throw new IllegalStateException("A non-ModularSlot was found, but all slots in a ModularContainer must extend ModularSlot.");
    }

    public List<ModularSlot> getShiftClickSlots() {
        return Collections.unmodifiableList(this.shiftClickSlots);
    }

    public void onSlotChanged(ModularSlot slot, ItemStack stack, boolean onlyAmountChanged) {
    }

    public boolean func_75145_c(@NotNull EntityPlayer playerIn) {
        return this.settings.canPlayerInteractWithUI(playerIn);
    }

    public ItemStack func_75144_a(int slotId, int mouseButton, int mode, EntityPlayer player) {
        ClickType clickTypeIn = ClickType.fromNumber(mode);
        ItemStack returnable = null;
        InventoryPlayer inventoryplayer = player.field_71071_by;
        if (clickTypeIn == ClickType.QUICK_CRAFT || this.acc().getDragEvent() != 0) {
            return super.func_75144_a(slotId, mouseButton, mode, player);
        }
        if (!(clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || mouseButton != 0 && mouseButton != 1)) {
            if (slotId == -999) {
                return this.superSlotClick(slotId, mouseButton, mode, player);
            }
            if (slotId < 0) {
                return Platform.EMPTY_STACK;
            }
            if (clickTypeIn == ClickType.QUICK_MOVE) {
                Slot fromSlot = this.func_75139_a(slotId);
                if (!fromSlot.func_82869_a(player)) {
                    return Platform.EMPTY_STACK;
                }
                returnable = NEAAnimationHandler.shouldHandleNEA(this) ? NEAAnimationHandler.injectQuickMove(this, player, slotId, fromSlot) : this.handleQuickMove(player, slotId, fromSlot);
            } else {
                Slot clickedSlot = this.func_75139_a(slotId);
                if (clickedSlot != null) {
                    ItemStack slotStack = clickedSlot.func_75211_c();
                    ItemStack heldStack = inventoryplayer.func_70445_o();
                    if (slotStack == null) {
                        if (heldStack != null && clickedSlot.func_75214_a(heldStack)) {
                            int stackCount;
                            int n = stackCount = mouseButton == 0 ? heldStack.field_77994_a : 1;
                            if (stackCount > clickedSlot.func_75219_a()) {
                                stackCount = clickedSlot.func_75219_a();
                            }
                            clickedSlot.func_75215_d(heldStack.func_77979_a(stackCount));
                            if (heldStack.field_77994_a == 0) {
                                inventoryplayer.func_70437_b(null);
                            }
                        }
                    } else if (clickedSlot.func_82869_a(player)) {
                        int stackCount;
                        if (heldStack == null) {
                            int s = Math.min(slotStack.field_77994_a, slotStack.func_77976_d());
                            int toRemove = mouseButton == 0 ? s : (s + 1) / 2;
                            inventoryplayer.func_70437_b(slotStack.func_77979_a(toRemove));
                            if (slotStack.field_77994_a == 0) {
                                slotStack = null;
                            }
                            clickedSlot.func_75215_d(slotStack);
                            clickedSlot.func_82870_a(player, inventoryplayer.func_70445_o());
                        } else if (clickedSlot.func_75214_a(heldStack)) {
                            if (slotStack.func_77973_b() == heldStack.func_77973_b() && slotStack.func_77960_j() == heldStack.func_77960_j() && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)heldStack)) {
                                int stackCount2;
                                int n = stackCount2 = mouseButton == 0 ? heldStack.field_77994_a : 1;
                                if (stackCount2 > clickedSlot.func_75219_a() - slotStack.field_77994_a) {
                                    stackCount2 = clickedSlot.func_75219_a() - slotStack.field_77994_a;
                                }
                                heldStack.func_77979_a(stackCount2);
                                if (heldStack.field_77994_a == 0) {
                                    inventoryplayer.func_70437_b(null);
                                }
                                slotStack.field_77994_a += stackCount2;
                                clickedSlot.func_75215_d(slotStack);
                            } else if (heldStack.field_77994_a <= clickedSlot.func_75219_a()) {
                                clickedSlot.func_75215_d(heldStack);
                                inventoryplayer.func_70437_b(slotStack);
                            }
                        } else if (slotStack.func_77973_b() == heldStack.func_77973_b() && heldStack.func_77976_d() > 1 && (!slotStack.func_77981_g() || slotStack.func_77960_j() == heldStack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)heldStack) && (stackCount = slotStack.field_77994_a) > 0 && stackCount + heldStack.field_77994_a <= heldStack.func_77976_d()) {
                            heldStack.field_77994_a += stackCount;
                            slotStack = clickedSlot.func_75209_a(stackCount);
                            if (slotStack.field_77994_a == 0) {
                                clickedSlot.func_75215_d(null);
                            }
                            clickedSlot.func_82870_a(player, inventoryplayer.func_70445_o());
                        }
                    }
                    clickedSlot.func_75218_e();
                }
            }
            this.func_75142_b();
            return returnable;
        }
        return this.superSlotClick(slotId, mouseButton, mode, player);
    }

    @NotNull
    protected final ItemStack superSlotClick(int slotId, int mouseButton, int mode, @NotNull EntityPlayer player) {
        return super.func_75144_a(slotId, mouseButton, mode, player);
    }

    public final ItemStack handleQuickMove(EntityPlayer player, int slotId, Slot fromSlot) {
        ItemStack returnable;
        ItemStack remainder;
        do {
            remainder = this.func_82846_b(player, slotId);
            returnable = Platform.copyStack(remainder);
        } while (!Platform.isStackEmpty(remainder) && ItemHandlerHelper.canItemStacksStack(fromSlot.func_75211_c(), remainder));
        return returnable;
    }

    @Nullable
    public ItemStack func_82846_b(@NotNull EntityPlayer playerIn, int index) {
        ItemStack stack;
        ModularSlot slot = this.getModularSlot(index);
        if (!slot.isPhantom() && (stack = slot.func_75211_c()) != null) {
            ItemStack remainder;
            ItemStack copy = stack.func_77946_l();
            stack = stack.func_77946_l();
            int base = 0;
            if (stack.field_77994_a > stack.func_77976_d()) {
                base = stack.field_77994_a - stack.func_77976_d();
                stack.field_77994_a = stack.func_77976_d();
            }
            if (ItemStack.func_77989_b((ItemStack)(remainder = this.transferItem(slot, stack.func_77946_l())), (ItemStack)stack)) {
                return Platform.EMPTY_STACK;
            }
            if (base == 0 && (remainder == null || remainder.field_77994_a < 1)) {
                stack = null;
            } else {
                stack.field_77994_a = base + remainder.field_77994_a;
            }
            slot.func_75215_d(stack);
            slot.func_75220_a(remainder, copy);
            slot.func_82870_a(playerIn, remainder);
            slot.onCraftShiftClick(playerIn, remainder);
            return copy;
        }
        return null;
    }

    protected ItemStack transferItem(ModularSlot fromSlot, ItemStack fromStack) {
        @Nullable SlotGroup fromSlotGroup = fromSlot.getSlotGroup();
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.func_111238_b() || !toSlot.func_75214_a(fromStack)) continue;
            ItemStack toStack = toSlot.func_75211_c();
            if (fromSlot.isPhantom() || !ItemHandlerHelper.canItemStacksStack(fromStack, toStack)) continue;
            int j = toStack.field_77994_a + fromStack.field_77994_a;
            int maxSize = toSlot.getItemStackLimit(fromStack);
            if (j <= maxSize) {
                fromStack.field_77994_a = 0;
                toStack.field_77994_a = j;
                toSlot.func_75218_e();
            } else if (toStack.field_77994_a < maxSize) {
                fromStack.field_77994_a -= maxSize - toStack.field_77994_a;
                toStack.field_77994_a = maxSize;
                toSlot.func_75218_e();
            }
            if (fromStack.field_77994_a >= 1) continue;
            return fromStack;
        }
        boolean hasNonEmptyPhantom = false;
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            ItemStack itemstack = toSlot.func_75211_c();
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.func_111238_b() || !toSlot.func_75214_a(fromStack)) continue;
            if (toSlot.isPhantom()) {
                if (!Platform.isStackEmpty(itemstack)) {
                    hasNonEmptyPhantom = true;
                    continue;
                }
                toSlot.func_75215_d(fromStack.func_77946_l());
                return fromStack;
            }
            if (!Platform.isStackEmpty(itemstack)) continue;
            if (fromStack.field_77994_a > toSlot.getItemStackLimit(fromStack)) {
                toSlot.func_75215_d(fromStack.func_77979_a(toSlot.getItemStackLimit(fromStack)));
            } else {
                toSlot.func_75215_d(fromStack.func_77979_a(fromStack.field_77994_a));
            }
            if (fromStack.field_77994_a >= 1) continue;
            break;
        }
        if (!hasNonEmptyPhantom) {
            return fromStack;
        }
        for (ModularSlot toSlot : this.getShiftClickSlots()) {
            SlotGroup slotGroup = Objects.requireNonNull(toSlot.getSlotGroup());
            if (slotGroup == fromSlotGroup || !toSlot.isPhantom() || !toSlot.func_111238_b() || !toSlot.func_75214_a(fromStack)) continue;
            toSlot.func_75215_d(fromStack.func_77946_l());
            return fromStack;
        }
        return fromStack;
    }
}

