/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable;

import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.UITexture;
import com.cleanroommc.modularui.utils.GlStateManager;
import com.google.gson.JsonObject;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class AdaptableUITexture
extends UITexture {
    private final int imageWidth;
    private final int imageHeight;
    private final int bl;
    private final int bt;
    private final int br;
    private final int bb;
    private final boolean tiled;

    AdaptableUITexture(ResourceLocation location, float u0, float v0, float u1, float v1, boolean background, int imageWidth, int imageHeight, int bl, int bt, int br, int bb, boolean tiled) {
        super(location, u0, v0, u1, v1, background);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.bl = bl;
        this.bt = bt;
        this.br = br;
        this.bb = bb;
        this.tiled = tiled;
    }

    @Override
    public AdaptableUITexture getSubArea(float uStart, float vStart, float uEnd, float vEnd) {
        return new AdaptableUITexture(this.location, this.lerpU(uStart), this.lerpV(vStart), this.lerpU(uEnd), this.lerpV(vEnd), this.canApplyTheme, this.imageWidth, this.imageHeight, this.bl, this.bt, this.br, this.bb, this.tiled);
    }

    @Override
    public void draw(float x, float y, float width, float height) {
        if (width == (float)this.imageWidth && height == (float)this.imageHeight) {
            super.draw(x, y, width, height);
            return;
        }
        if (this.tiled) {
            this.drawTiled(x, y, width, height);
        } else {
            this.drawStretched(x, y, width, height);
        }
    }

    public void drawStretched(float x, float y, float width, float height) {
        if (this.bl <= 0 && this.bt <= 0 && this.br <= 0 && this.bb <= 0) {
            super.draw(x, y, width, height);
            return;
        }
        GlStateManager.disableAlpha();
        GlStateManager.enableBlend();
        GlStateManager.enableTexture2D();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.location);
        float uBl = (float)this.bl * 1.0f / (float)this.imageWidth;
        float uBr = (float)this.br * 1.0f / (float)this.imageWidth;
        float vBt = (float)this.bt * 1.0f / (float)this.imageHeight;
        float vBb = (float)this.bb * 1.0f / (float)this.imageHeight;
        float x1 = x + width;
        float y1 = y + height;
        float uInnerStart = this.u0 + uBl;
        float vInnerStart = this.v0 + vBt;
        float uInnerEnd = this.u1 - uBr;
        float vInnerEnd = this.v1 - vBb;
        if ((this.bl > 0 || this.br > 0) && this.bt <= 0 && this.bb <= 0) {
            GuiDraw.drawTexture(x, y, x + (float)this.bl, y1, this.u0, this.v0, uInnerStart, this.v1);
            GuiDraw.drawTexture(x1 - (float)this.br, y, x1, y1, uInnerEnd, this.v0, this.u1, this.v1);
            GuiDraw.drawTexture(x + (float)this.bl, y, x1 - (float)this.br, y1, uInnerStart, this.v0, uInnerEnd, this.v1);
        } else if (this.bl <= 0 && this.br <= 0) {
            GuiDraw.drawTexture(x, y, x1, y + (float)this.bt, this.u0, this.v0, this.u1, vInnerStart);
            GuiDraw.drawTexture(x, y1 - (float)this.bb, x1, y1, this.u0, vInnerEnd, this.u1, this.v1);
            GuiDraw.drawTexture(x, y + (float)this.bt, x1, y1 - (float)this.bb, this.u0, vInnerStart, this.u1, vInnerEnd);
        } else {
            GuiDraw.drawTexture(x, y, x + (float)this.bl, y + (float)this.bt, this.u0, this.v0, uInnerStart, vInnerStart);
            GuiDraw.drawTexture(x1 - (float)this.br, y, x1, y + (float)this.bt, uInnerEnd, this.v0, this.u1, vInnerStart);
            GuiDraw.drawTexture(x, y1 - (float)this.bb, x + (float)this.bl, y1, this.u0, vInnerEnd, uInnerStart, this.v1);
            GuiDraw.drawTexture(x1 - (float)this.br, y1 - (float)this.bb, x1, y1, uInnerEnd, vInnerEnd, this.u1, this.v1);
            GuiDraw.drawTexture(x, y + (float)this.bt, x + (float)this.bl, y1 - (float)this.bb, this.u0, vInnerStart, uInnerStart, vInnerEnd);
            GuiDraw.drawTexture(x + (float)this.bl, y, x1 - (float)this.br, y + (float)this.bt, uInnerStart, this.v0, uInnerEnd, vInnerStart);
            GuiDraw.drawTexture(x1 - (float)this.br, y + (float)this.bt, x1, y1 - (float)this.bb, uInnerEnd, vInnerStart, this.u1, vInnerEnd);
            GuiDraw.drawTexture(x + (float)this.bl, y1 - (float)this.bb, x1 - (float)this.br, y1, uInnerStart, vInnerEnd, uInnerEnd, this.v1);
            GuiDraw.drawTexture(x + (float)this.bl, y + (float)this.bt, x1 - (float)this.br, y1 - (float)this.bb, uInnerStart, vInnerStart, uInnerEnd, vInnerEnd);
        }
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
    }

    public void drawTiled(float x, float y, float width, float height) {
        if (this.bl <= 0 && this.bt <= 0 && this.br <= 0 && this.bb <= 0) {
            GuiDraw.drawTiledTexture(this.location, x, y, width, height, this.u0, this.v0, this.u1, this.v1, this.imageWidth, this.imageHeight, 0.0f);
            return;
        }
        GlStateManager.disableAlpha();
        GlStateManager.enableBlend();
        GlStateManager.enableTexture2D();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.location);
        float uBl = (float)this.bl * 1.0f / (float)this.imageWidth;
        float uBr = (float)this.br * 1.0f / (float)this.imageWidth;
        float vBt = (float)this.bt * 1.0f / (float)this.imageHeight;
        float vBb = (float)this.bb * 1.0f / (float)this.imageHeight;
        float x1 = x + width;
        float y1 = y + height;
        float uInnerStart = this.u0 + uBl;
        float vInnerStart = this.v0 + vBt;
        float uInnerEnd = this.u1 - uBr;
        float vInnerEnd = this.v1 - vBb;
        int tw = (int)((float)this.imageWidth * (this.u1 - this.u0));
        int th = (int)((float)this.imageHeight * (this.v1 - this.v0));
        if ((this.bl > 0 || this.br > 0) && this.bt <= 0 && this.bb <= 0) {
            GuiDraw.drawTiledTexture(x, y, (float)this.bl, height, this.u0, this.v0, uInnerStart, this.v1, this.bl, th, 0.0f);
            GuiDraw.drawTiledTexture(x1 - (float)this.br, y, (float)this.br, height, uInnerEnd, this.v0, this.u1, this.v1, this.br, th, 0.0f);
            GuiDraw.drawTiledTexture(x + (float)this.bl, y, width - (float)this.bl - (float)this.br, height, uInnerStart, this.v0, uInnerEnd, this.v1, tw - this.bl - this.br, th, 0.0f);
        } else if (this.bl <= 0 && this.br <= 0) {
            GuiDraw.drawTiledTexture(x, y, width, (float)this.bt, this.u0, this.v0, this.u1, vInnerStart, tw, this.bt, 0.0f);
            GuiDraw.drawTiledTexture(x, y1 - (float)this.bb, width, (float)this.bb, this.u0, vInnerEnd, this.u1, this.v1, tw, this.bb, 0.0f);
            GuiDraw.drawTiledTexture(x, y + (float)this.bt, width, height - (float)this.bt - (float)this.bb, this.u0, vInnerStart, this.u1, vInnerEnd, tw, th - this.bt - this.bb, 0.0f);
        } else {
            GuiDraw.drawTiledTexture(x, y, (float)this.bl, (float)this.bt, this.u0, this.v0, uInnerStart, vInnerStart, this.bl, this.bt, 0.0f);
            GuiDraw.drawTiledTexture(x1 - (float)this.br, y, (float)this.br, (float)this.bt, uInnerEnd, this.v0, this.u1, vInnerStart, this.br, this.bt, 0.0f);
            GuiDraw.drawTiledTexture(x, y1 - (float)this.bb, (float)this.bl, (float)this.bb, this.u0, vInnerEnd, uInnerStart, this.v1, this.bl, this.bb, 0.0f);
            GuiDraw.drawTiledTexture(x1 - (float)this.br, y1 - (float)this.bb, (float)this.br, (float)this.bb, uInnerEnd, vInnerEnd, this.u1, this.v1, this.br, this.bb, 0.0f);
            GuiDraw.drawTiledTexture(x, y + (float)this.bt, (float)this.bl, height - (float)this.bt - (float)this.bb, this.u0, vInnerStart, uInnerStart, vInnerEnd, this.bl, th - this.bt - this.bb, 0.0f);
            GuiDraw.drawTiledTexture(x + (float)this.bl, y, width - (float)this.bl - (float)this.br, (float)this.bt, uInnerStart, this.v0, uInnerEnd, vInnerStart, tw - this.bl - this.bb, this.bt, 0.0f);
            GuiDraw.drawTiledTexture(x1 - (float)this.br, y + (float)this.bt, (float)this.br, height - (float)this.bt - (float)this.bb, uInnerEnd, vInnerStart, this.u1, vInnerEnd, this.br, th - this.bt - this.bb, 0.0f);
            GuiDraw.drawTiledTexture(x + (float)this.bl, y1 - (float)this.bb, width - (float)this.bl - (float)this.br, (float)this.bb, uInnerStart, vInnerEnd, uInnerEnd, this.v1, tw - this.bl - this.br, this.bb, 0.0f);
            GuiDraw.drawTiledTexture(x + (float)this.bl, y + (float)this.bt, width - (float)this.bl - (float)this.br, height - (float)this.bt - (float)this.bb, uInnerStart, vInnerStart, uInnerEnd, vInnerEnd, tw - this.bl - this.br, th - this.bt - this.bb, 0.0f);
        }
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
    }

    @Override
    public boolean saveToJson(JsonObject json) {
        super.saveToJson(json);
        if (json.entrySet().size() == 1) {
            return true;
        }
        json.addProperty("imageWidth", (Number)this.imageWidth);
        json.addProperty("imageHeight", (Number)this.imageHeight);
        json.addProperty("bl", (Number)this.bl);
        json.addProperty("br", (Number)this.br);
        json.addProperty("bt", (Number)this.bt);
        json.addProperty("bb", (Number)this.bb);
        json.addProperty("tiled", Boolean.valueOf(this.tiled));
        return true;
    }
}

