/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.components;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import stevesaddons.asm.StevesHooks;
import stevesaddons.components.ComponentMenuTriggered;
import stevesaddons.helpers.StevesEnum;
import vswe.stevesfactory.components.ConnectionOption;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.RadioButton;
import vswe.stevesfactory.components.RadioButtonList;
import vswe.stevesfactory.components.TextBoxNumber;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

public class ComponentMenuDelayed
extends ComponentMenuTriggered {
    private static final int TEXT_BOX_X = 15;
    private static final int TEXT_BOX_Y = 35;
    private static final int MENU_WIDTH = 120;
    private static final int TEXT_MARGIN_X = 5;
    private static final int TEXT_Y = 10;
    private TextBoxNumber intervalTicks;
    private TextBoxNumber intervalSeconds = new TextBoxNumber(15, 35, 3, true){

        public void onNumberChanged() {
            DataWriter dw = ComponentMenuDelayed.this.getWriterForServerComponentPacket();
            dw.writeData(ComponentMenuDelayed.this.getDelay(), DataBitHelper.MENU_INTERVAL);
            dw.writeBoolean(ComponentMenuDelayed.this.buttonList.getSelectedOption() == 0);
            PacketHandler.sendDataToServer((DataWriter)dw);
        }
    };
    private RadioButtonList buttonList;
    private static final EnumSet<ConnectionOption> delayed = EnumSet.of(StevesEnum.DELAYED_OUTPUT);
    private static final String NBT_RESTART = "Restart";

    public ComponentMenuDelayed(FlowComponent parent) {
        super(parent);
        this.textBoxes.addTextBox(this.intervalSeconds);
        this.intervalTicks = new TextBoxNumber(15 + this.intervalSeconds.getWidth() + 5, 35, 2, true){

            public void onNumberChanged() {
                DataWriter dw = ComponentMenuDelayed.this.getWriterForServerComponentPacket();
                dw.writeData(ComponentMenuDelayed.this.getDelay(), DataBitHelper.MENU_INTERVAL);
                dw.writeBoolean(ComponentMenuDelayed.this.buttonList.getSelectedOption() == 0);
                PacketHandler.sendDataToServer((DataWriter)dw);
            }

            public int getMaxNumber() {
                return 19;
            }
        };
        this.textBoxes.addTextBox(this.intervalTicks);
        this.buttonList = new RadioButtonList(){

            public void updateSelectedOption(int i) {
                this.setSelectedOption(i);
                DataWriter dw = ComponentMenuDelayed.this.getWriterForServerComponentPacket();
                dw.writeData(ComponentMenuDelayed.this.getDelay(), DataBitHelper.MENU_INTERVAL);
                dw.writeBoolean(ComponentMenuDelayed.this.buttonList.getSelectedOption() == 0);
                PacketHandler.sendDataToServer((DataWriter)dw);
            }
        };
        this.buttonList.add(new RadioButton(5, 55, StevesEnum.DELAY_RESTART));
        this.buttonList.add(new RadioButton(25 + this.intervalSeconds.getWidth(), 55, StevesEnum.DELAY_IGNORE));
        this.setDelay(5);
        this.buttonList.setSelectedOption(0);
    }

    @Override
    public void draw(GuiManager gui, int mX, int mY) {
        gui.drawSplitString(StevesEnum.DELAY_INFO.toString(), 5, 10, 115, 0.7f, 0x404040);
        this.buttonList.draw(gui, mX, mY);
        super.draw(gui, mX, mY);
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        super.onClick(mX, mY, button);
        this.buttonList.onClick(mX, mY, button);
    }

    @Override
    public void writeData(DataWriter dw) {
        super.writeData(dw);
        dw.writeBoolean(this.buttonList.getSelectedOption() == 0);
    }

    @Override
    public void readData(DataReader dr) {
        super.readData(dr);
        this.buttonList.setSelectedOption(dr.readBoolean() ? 0 : 1);
    }

    @Override
    public int getDelay() {
        return this.intervalTicks.getNumber() + this.intervalSeconds.getNumber() * 20;
    }

    @Override
    public void setDelay(int val) {
        this.intervalTicks.setNumber(val % 20);
        this.intervalSeconds.setNumber(val / 20);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        super.readFromNBT(nbtTagCompound, version, pickup);
        if (this.isVisible() && this.counter >= 0) {
            StevesHooks.registerTicker(this.getParent(), this);
        }
        this.buttonList.setSelectedOption(nbtTagCompound.func_74767_n(NBT_RESTART) ? 0 : 1);
    }

    public void addErrors(List<String> errors) {
        if (this.getDelay() < 5 && this.isVisible()) {
            errors.add(StevesEnum.DELAY_ERROR.toString());
        }
    }

    @Override
    protected EnumSet<ConnectionOption> getConnectionSets() {
        return delayed;
    }

    @Override
    public void setCountdown() {
        int selected = this.buttonList.getSelectedOption();
        if (this.getDelay() >= 5 && (selected == 0 || selected == 1 && this.counter == -1)) {
            super.setCountdown();
        }
    }

    public String getName() {
        return StevesEnum.DELAY_TRIGGER.toString();
    }

    public boolean isVisible() {
        return this.getParent().getConnectionSet() == StevesEnum.DELAYED;
    }

    @Override
    public boolean remove() {
        return this.counter < 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        super.writeToNBT(nbtTagCompound, pickup);
        nbtTagCompound.func_74757_a(NBT_RESTART, this.buttonList.getSelectedOption() == 0);
    }

    @Override
    protected void resetCounter() {
        this.counter = -1;
    }
}

