/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.guis.module.inhand.ApiaristSinkModuleInHand;
import logisticspipes.network.guis.module.inpipe.ApiaristSinkModuleSlot;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ModuleApiaristSink
extends LogisticsGuiModule {
    public SinkSetting[] filter = new SinkSetting[6];
    private SinkReply _sinkReply;

    public ModuleApiaristSink() {
        this.filter[0] = new SinkSetting(this);
        this.filter[1] = new SinkSetting(this);
        this.filter[2] = new SinkSetting(this);
        this.filter[3] = new SinkSetting(this);
        this.filter[4] = new SinkSetting(this);
        this.filter[5] = new SinkSetting(this);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound filters = nbttagcompound.func_74775_l("filters");
        for (int i = 0; i < this.filter.length; ++i) {
            NBTTagCompound filterNBT = filters.func_74775_l("" + i);
            this.filter[i].readFromNBT(filterNBT);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound filters = new NBTTagCompound();
        for (int i = 0; i < this.filter.length; ++i) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            this.filter[i].writeToNBT(filterNBT);
            filters.func_74782_a("" + i, (NBTBase)filterNBT);
        }
        nbttagcompound.func_74782_a("filters", (NBTBase)filters);
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return NewGuiHandler.getGui(ApiaristSinkModuleSlot.class).setNbt(tag);
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ApiaristSinkModuleInHand.class);
    }

    public boolean isFiltered(ItemIdentifier item) {
        for (int i = 0; i < 6; ++i) {
            Boolean accept = null;
            for (SinkSetting setting : this.filter) {
                if (setting.filterGroup - 1 != i) continue;
                accept = accept == null ? Boolean.valueOf(setting.isFiltered(item)) : Boolean.valueOf(accept != false && setting.isFiltered(item));
            }
            if (accept == null || !accept.booleanValue()) continue;
            return true;
        }
        for (SinkSetting setting : this.filter) {
            if (setting.filterGroup != 0 || !setting.isFiltered(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.APIARIST_BeeSink, 0, true, false, 2, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier itemID, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        ItemStack item = itemID.makeNormalStack(1);
        if (SimpleServiceLocator.forestryProxy.isBee(item) && SimpleServiceLocator.forestryProxy.isAnalysedBee(item) && this.isFiltered(itemID) && this._service.canUseEnergy(2)) {
            return this._sinkReply;
        }
        return null;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleApiaristSink");
    }

    public static class SinkSetting {
        private final ModuleApiaristSink module;
        public FilterType filterType = FilterType.Null;
        public String firstBee = "";
        public String secondBee = "";
        public int filterGroup = 0;

        public SinkSetting(ModuleApiaristSink module) {
            this.module = module;
        }

        public void firstBeeUp() {
            this.firstBee = SimpleServiceLocator.forestryProxy.getNextAlleleId(this.firstBee, this.module._world.getWorld());
        }

        public void firstBeeDown() {
            this.firstBee = SimpleServiceLocator.forestryProxy.getPrevAlleleId(this.firstBee, this.module._world.getWorld());
        }

        public void firstBeeReset() {
            this.firstBee = "";
        }

        public void secondBeeUp() {
            this.secondBee = SimpleServiceLocator.forestryProxy.getNextAlleleId(this.secondBee, this.module._world.getWorld());
        }

        public void secondBeeDown() {
            this.secondBee = SimpleServiceLocator.forestryProxy.getPrevAlleleId(this.secondBee, this.module._world.getWorld());
        }

        public void secondBeeReset() {
            this.secondBee = "";
        }

        public void filterGroupUp() {
            this.filterGroup = this.filterGroup <= 5 ? ++this.filterGroup : 0;
        }

        public void filterGroupDown() {
            this.filterGroup = this.filterGroup >= 1 ? --this.filterGroup : 6;
        }

        public void filterGroupReset() {
            this.filterGroup = 0;
        }

        public void FilterTypeUp() {
            this.filterType = this.filterType.ordinal() + 1 >= FilterType.values().length ? FilterType.values()[0] : FilterType.values()[this.filterType.ordinal() + 1];
        }

        public void FilterTypeDown() {
            this.filterType = this.filterType.ordinal() - 1 < 0 ? FilterType.values()[FilterType.values().length - 1] : FilterType.values()[this.filterType.ordinal() - 1];
        }

        public void FilterTypeReset() {
            this.filterType = FilterType.Null;
        }

        public void readFromNBT(NBTTagCompound nbttagcompound) {
            this.filterType = nbttagcompound.func_74764_b("filterType") ? FilterType.values()[nbttagcompound.func_74762_e("filterType")] : FilterType.Null;
            this.firstBee = nbttagcompound.func_74779_i("firstBeeString");
            this.secondBee = nbttagcompound.func_74779_i("secondBeeString");
            this.filterGroup = nbttagcompound.func_74762_e("filterGroup");
        }

        public void writeToNBT(NBTTagCompound nbttagcompound) {
            nbttagcompound.func_74768_a("filterType", this.filterType.ordinal());
            nbttagcompound.func_74778_a("firstBeeString", this.firstBee);
            nbttagcompound.func_74778_a("secondBeeString", this.secondBee);
            nbttagcompound.func_74768_a("filterGroup", this.filterGroup);
        }

        private boolean allAllele(ItemStack bee) {
            return this.firstAllele(bee) && this.secondAllele(bee);
        }

        private boolean firstAllele(ItemStack bee) {
            return SimpleServiceLocator.forestryProxy.getFirstAlleleId(bee).equals(this.firstBee) || this.firstBee.equals("");
        }

        private boolean secondAllele(ItemStack bee) {
            return SimpleServiceLocator.forestryProxy.getSecondAlleleId(bee).equals(this.secondBee) || this.secondBee.equals("");
        }

        public boolean isFiltered(ItemIdentifier itemID) {
            ItemStack item = itemID.makeNormalStack(1);
            switch (this.filterType) {
                case BeeAllele: {
                    return this.allAllele(item);
                }
                case Drone: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isDrone(item);
                }
                case Princess: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isPrincess(item);
                }
                case Queen: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isQueen(item);
                }
                case Purebred: {
                    return this.firstAllele(item) && SimpleServiceLocator.forestryProxy.isPurebred(item);
                }
                case Nocturnal: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isNocturnal(item);
                }
                case PureNocturnal: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isPureNocturnal(item);
                }
                case Flyer: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isFlyer(item);
                }
                case PureFlyer: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isPureFlyer(item);
                }
                case Cave: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isCave(item);
                }
                case PureCave: {
                    return this.allAllele(item) && SimpleServiceLocator.forestryProxy.isPureCave(item);
                }
            }
            return false;
        }
    }

    public static enum FilterType {
        Null("", "anything", 0),
        BeeAllele("gui.pipe.filter.BEE", "bee", 2),
        Drone("gui.pipe.filter.DRONE", "drone", 2),
        Princess("gui.pipe.filter.PRINCESS", "princess", 2),
        Queen("gui.pipe.filter.QUEEN", "queen", 2),
        Purebred("gui.pipe.filter.PURE_BREED", "pure_breed", 1),
        Nocturnal("gui.pipe.filter.NOCTURNAL", "nocturnal", 2),
        PureNocturnal("gui.pipe.filter.PURE_NOCTURNAL", "pure_nocturnal", 2),
        Flyer("gui.pipe.filter.FLYER", "flyer", 2),
        PureFlyer("gui.pipe.filter.PURE_FLYER", "pure_flyer", 2),
        Cave("gui.pipe.filter.CAVE", "cave", 2),
        PureCave("gui.pipe.filter.PURE_CAVE", "pure_flyer", 2);

        public String path;
        public String icon;
        public int secondSlots;

        private FilterType(String text, String id, int secondSlot) {
            this.path = text;
            this.icon = id;
            this.secondSlots = secondSlot;
        }
    }
}

