/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import crazypants.enderio.conduit.ConduitUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class ConduitTank
implements IFluidTank {
    private FluidStack fluid;
    private int capacity;

    ConduitTank(int capacity) {
        this.capacity = capacity;
    }

    public int getFluidAmount() {
        return this.fluid == null ? 0 : this.fluid.amount;
    }

    public float getFilledRatio() {
        if (this.getFluidAmount() <= 0) {
            return 0.0f;
        }
        if (this.getCapacity() <= 0) {
            return -1.0f;
        }
        float res = (float)this.getFluidAmount() / (float)this.getCapacity();
        return res;
    }

    public boolean isFull() {
        return this.getFluidAmount() >= this.getCapacity();
    }

    public void setAmount(int amount) {
        if (this.fluid != null) {
            this.fluid.amount = amount;
        }
    }

    public int getAvailableSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public void addAmount(int amount) {
        this.setAmount(this.getFluidAmount() + amount);
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setLiquid(FluidStack liquid) {
        this.fluid = liquid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.getFluidAmount() > capacity) {
            this.setAmount(capacity);
        }
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluidID() <= 0) {
            return 0;
        }
        if (this.fluid == null || this.fluid.getFluidID() <= 0) {
            if (resource.amount <= this.capacity) {
                if (doFill) {
                    this.setLiquid(resource.copy());
                }
                return resource.amount;
            }
            if (doFill) {
                this.fluid = resource.copy();
                this.fluid.amount = this.capacity;
            }
            return this.capacity;
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int space = this.capacity - this.fluid.amount;
        if (resource.amount <= space) {
            if (doFill) {
                this.addAmount(resource.amount);
            }
            return resource.amount;
        }
        if (doFill) {
            this.fluid.amount = this.capacity;
        }
        return space;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluid == null || this.fluid.getFluidID() <= 0) {
            return null;
        }
        if (this.fluid.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.fluid.amount < used) {
            used = this.fluid.amount;
        }
        if (doDrain) {
            this.addAmount(-used);
        }
        FluidStack drained = new FluidStack(this.fluid.getFluid(), used);
        if (this.fluid.amount < 0) {
            this.fluid.amount = 0;
        }
        return drained;
    }

    public void setTankPressure(int pressure) {
    }

    public String getLiquidName() {
        return this.fluid != null ? FluidRegistry.getFluidName((FluidStack)this.fluid) : null;
    }

    public boolean containsValidLiquid() {
        return ConduitUtil.isFluidValid(this.fluid);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.containsValidLiquid()) {
            this.fluid.writeToNBT(nbt);
        } else {
            nbt.func_74757_a("emptyTank", true);
        }
        return nbt;
    }

    public IFluidTank readFromNBT(NBTTagCompound nbt) {
        FluidStack liquid;
        if (!nbt.func_74764_b("emptyTank") && (liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt)) != null) {
            this.setLiquid(liquid);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.fluid == null || this.fluid.amount == 0;
    }
}

