/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.tcwands.api;

import com.gtnewhorizons.tcwands.api.GTTier;
import com.gtnewhorizons.tcwands.api.TCWandAPI;
import com.gtnewhorizons.tcwands.api.WandType;
import com.gtnewhorizons.tcwands.api.wandinfo.WandDetails;
import com.gtnewhorizons.tcwands.api.wandinfo.WandProps;
import com.gtnewhorizons.tcwands.api.wrappers.AbstractWandWrapper;
import com.gtnewhorizons.tcwands.api.wrappers.SceptreWrapper;
import com.gtnewhorizons.tcwands.api.wrappers.StaffSceptreWrapper;
import com.gtnewhorizons.tcwands.api.wrappers.StaffWrapper;
import com.gtnewhorizons.tcwands.api.wrappers.WandWrapper;
import net.minecraft.item.ItemStack;

public class WandRecipeCreator {
    private String name;
    private WandDetails wandDetails = null;
    private WandDetails staffDetails = null;
    private WandProps wandProps = null;
    private WandProps staffProps = null;
    private String customResearchName = null;
    private ItemStack customCraftingRod = null;

    public WandRecipeCreator(String name) {
        this.name = name;
    }

    public WandRecipeCreator applyCustomResearchName(String customResearchName) {
        this.customResearchName = customResearchName;
        return this;
    }

    public WandRecipeCreator regWandRecipe(int baseCost, int capCost, GTTier tier) {
        return this.regWandRecipe(baseCost, capCost, tier, tier.getConductor());
    }

    public WandRecipeCreator regWandRecipe(int baseCost, int capCost, GTTier tier, ItemStack conductor) {
        this.wandProps = new WandProps(baseCost, capCost);
        this.wandDetails = new WandDetails(this.name, tier, conductor);
        this.regWandWrapper(new WandWrapper(this.wandDetails, this.wandProps));
        return this;
    }

    public WandRecipeCreator regWandRecipe(int baseCost, int capCost, ItemStack customCraftingRod, GTTier tier) {
        return this.regWandRecipe(baseCost, capCost, customCraftingRod, tier, tier.getConductor());
    }

    public WandRecipeCreator regWandRecipe(int baseCost, int capCost, ItemStack customCraftingRod, GTTier tier, ItemStack conductor) {
        this.customCraftingRod = customCraftingRod;
        return this.regWandRecipe(baseCost, capCost, tier, conductor);
    }

    public WandRecipeCreator regWandDepStaffRecipe(int baseCost, int capCost) {
        if (this.wandDetails == null) {
            throw new IllegalStateException("You can't use regStaffRecipe(int baseCost, int capCost) without calling regWandRecipe(...).");
        }
        this.staffProps = new WandProps(baseCost, capCost);
        this.regWandWrapper(new StaffWrapper(this.wandDetails, this.staffProps));
        return this;
    }

    public WandRecipeCreator regUpwardStaffRecipe(int baseCost, int capCost) {
        GTTier tier = this.wandDetails.getTier().nextTier();
        return this.regStaffRecipe(baseCost, capCost, tier);
    }

    public WandRecipeCreator regStaffRecipe(int baseCost, int capCost, GTTier tier) {
        return this.regStaffRecipe(baseCost, capCost, tier, tier.getConductor());
    }

    public WandRecipeCreator regStaffRecipe(int baseCost, int capCost, GTTier tier, ItemStack conductor) {
        this.staffProps = new WandProps(baseCost, capCost);
        this.staffDetails = new WandDetails(this.name, tier, conductor);
        this.regWandWrapper(new StaffWrapper(this.staffDetails, this.staffProps));
        return this;
    }

    public WandRecipeCreator regSceptreRecipe(float sceptreCostMultiplier) {
        if (this.wandDetails == null || this.wandProps == null) {
            throw new IllegalStateException("You can't use regSceptreRecipe(...) without calling regWandRecipe(...) method.");
        }
        SceptreWrapper sceptreWrapper = new SceptreWrapper(this.wandDetails, this.wandProps, sceptreCostMultiplier);
        this.regWandWrapper(sceptreWrapper);
        return this;
    }

    public WandRecipeCreator regStaffSceptreRecipe(float sceptreCostMultiplier) {
        if (this.staffDetails == null || this.staffProps == null) {
            throw new IllegalStateException("You can't use regStaffSceptreRecipe(...) without calling regStaffRecipe(...) method.");
        }
        StaffSceptreWrapper sceptreWrapper = new StaffSceptreWrapper(this.staffDetails, this.staffProps, sceptreCostMultiplier);
        this.regWandWrapper(sceptreWrapper);
        return this;
    }

    private void regWandWrapper(AbstractWandWrapper wandWrapper) {
        this.applyCustomizations(wandWrapper);
        TCWandAPI.regWandWrapper(wandWrapper);
    }

    private void applyCustomizations(AbstractWandWrapper wandWrapper) {
        if (this.customResearchName != null) {
            wandWrapper.setCustomResearchName(this.customResearchName);
            this.customResearchName = null;
        }
        if ((wandWrapper.getType() == WandType.WAND || wandWrapper.getType() == WandType.SCEPTRE) && this.customCraftingRod != null) {
            wandWrapper.setCustomCraftingRod(this.customCraftingRod);
        }
    }
}

