/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketTileStream
extends PacketCoordinates
implements IForestryPacketClient {
    private IStreamable streamable;

    public PacketTileStream() {
    }

    public <T extends TileEntity> PacketTileStream(T streamable) {
        super(streamable);
        this.streamable = (IStreamable)streamable;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.streamable.writeData(data);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IStreamable) {
            ((IStreamable)tile).readData(data);
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.TILE_FORESTRY_UPDATE;
    }
}

