/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.mixins.early.minecraft;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockStem;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import squeek.applecore.api.AppleCoreAPI;

@Mixin(value={BlockStem.class})
public class BlockStemMixin
extends BlockBush {
    @ModifyExpressionValue(method={"updateTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockLightValue(III)I")})
    private int redirectGetBlockLightValue(int original, World worldIn, int x, int y, int z, Random random) {
        int n;
        switch (AppleCoreAPI.dispatcher.validatePlantGrowth((Block)this, worldIn, x, y, z, random)) {
            case ALLOW: {
                n = 9;
                break;
            }
            case DEFAULT: {
                n = original;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Inject(method={"updateTick"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/World;getBlockMetadata(III)I")})
    private void onGetBlockMetadata(World world, int blockX, int blockY, int blockZ, Random random, CallbackInfo callbackInfo, @Local(name={"l"}) int l, @Share(value="previousMetadata") LocalIntRef previousMetadata) {
        previousMetadata.set(l);
    }

    @Inject(method={"updateTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockMetadataWithNotify(IIIII)Z", shift=At.Shift.AFTER)})
    private void afterSetBlockMetadataWithNotify(World world, int blockX, int blockY, int blockZ, Random random, CallbackInfo callbackInfo, @Share(value="previousMetadata") LocalIntRef previousMetadata) {
        AppleCoreAPI.dispatcher.announcePlantGrowth((Block)this, world, blockX, blockY, blockZ, previousMetadata.get());
    }
}

