/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymapserver.forge.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.techbrew.journeymapserver.common.config.ConfigHandler;
import net.techbrew.journeymapserver.common.mapcontrol.MappingOptionsHandler;
import net.techbrew.journeymapserver.common.network.PacketManager;
import net.techbrew.journeymapserver.common.util.LogHelper;

public class ForgeEvents {
    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void on(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayerMP) {
            String worldId = event.world.func_72912_H().func_76065_j();
            new UserJoinWorldThread((EntityPlayerMP)event.entity, ConfigHandler.getConfigByWorldName(worldId).getWorldID()).start();
        }
    }

    private class UserJoinWorldThread
    extends Thread {
        private String worldID;
        private EntityPlayerMP player;
        private MappingOptionsHandler options;

        public UserJoinWorldThread(EntityPlayerMP player, String worldID) {
            this.player = player;
            this.worldID = worldID;
            this.options = new MappingOptionsHandler(player.func_130014_f_().func_72912_H().func_76065_j());
        }

        @Override
        public void run() {
            try {
                UserJoinWorldThread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.options.disableRadar(this.player.func_70005_c_())) {
                LogHelper.info("Disabling Radar for player: " + this.player.func_70005_c_());
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e", new Object[0]));
            }
            if (this.options.disableCaveMapping(this.player.func_70005_c_())) {
                LogHelper.info("Disabling CaveMapping for player: " + this.player.func_70005_c_());
                this.player.func_145747_a((IChatComponent)new ChatComponentTranslation("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d", new Object[0]));
            }
            if (ConfigHandler.getConfigByWorldName(this.worldID).isUsingWorldID()) {
                LogHelper.info(String.format("Login: Sending WorldID Packet to %s", this.player.func_70005_c_()));
                PacketManager.instance.sendPlayerWorldID(this.worldID, this.player.func_70005_c_());
            }
        }
    }
}

