/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.modifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.modifier.IModifyable;

public abstract class ItemModifier {
    public final String key;
    public final List<ItemStack> stacks;
    public final int effectIndex;
    public static Random random = new Random();

    public ItemModifier(ItemStack[] recipe, int effect, String dataKey) {
        this.stacks = new ArrayList<ItemStack>(Arrays.asList(recipe));
        this.effectIndex = effect;
        this.key = dataKey;
    }

    public boolean matches(ItemStack[] recipe, ItemStack input) {
        if (!this.canModify(input, recipe)) {
            return false;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.stacks);
        for (ItemStack craftingStack : recipe) {
            if (craftingStack == null) continue;
            boolean canCraft = false;
            for (ItemStack removeStack : list) {
                if (craftingStack.func_77973_b() != removeStack.func_77973_b() || removeStack.func_77960_j() != Short.MAX_VALUE && craftingStack.func_77960_j() != removeStack.func_77960_j()) continue;
                canCraft = true;
                list.remove(removeStack);
                break;
            }
            if (canCraft) continue;
            return false;
        }
        return list.isEmpty();
    }

    protected String getTagName(ItemStack stack) {
        return ((IModifyable)stack.func_77973_b()).getBaseTagName();
    }

    protected NBTTagCompound getModifierTag(ItemStack stack) {
        return stack.func_77978_p().func_74775_l(this.getTagName(stack));
    }

    protected boolean canModify(ItemStack input, ItemStack[] recipe) {
        NBTTagCompound tags = input.func_77978_p().func_74775_l(this.getTagName(input));
        return tags.func_74762_e("Modifiers") > 0;
    }

    public abstract void modify(ItemStack[] var1, ItemStack var2);

    public void addMatchingEffect(ItemStack input) {
        NBTTagCompound tags = input.func_77978_p().func_74775_l(this.getTagName(input));
        if (tags.func_74764_b("Effect6") || tags.func_74764_b(this.key)) {
            return;
        }
        if (tags.func_74764_b("Effect5")) {
            tags.func_74768_a("Effect6", this.effectIndex);
        } else if (tags.func_74764_b("Effect4")) {
            tags.func_74768_a("Effect5", this.effectIndex);
        } else if (tags.func_74764_b("Effect3")) {
            tags.func_74768_a("Effect4", this.effectIndex);
        } else if (tags.func_74764_b("Effect2")) {
            tags.func_74768_a("Effect3", this.effectIndex);
        } else if (tags.func_74764_b("Effect1")) {
            tags.func_74768_a("Effect2", this.effectIndex);
        } else {
            tags.func_74768_a("Effect1", this.effectIndex);
        }
    }

    protected int addModifierTip(ItemStack input, String modifierTip) {
        String tip;
        NBTTagCompound tags = input.func_77978_p().func_74775_l(this.getTagName(input));
        int tipNum = 0;
        while (tags.func_74764_b(tip = "Tooltip" + ++tipNum)) {
        }
        tags.func_74778_a(tip, "");
        String modTip = "ModifierTip" + tipNum;
        tags.func_74778_a(modTip, modifierTip);
        return tipNum;
    }

    protected int addToolTip(ItemStack input, String tooltip, String modifierTip) {
        String tip;
        String tag;
        NBTTagCompound tags = input.func_77978_p().func_74775_l(this.getTagName(input));
        int tipNum = 0;
        do {
            if (tags.func_74764_b(tip = "Tooltip" + ++tipNum)) continue;
            tags.func_74778_a(tip, tooltip);
            String modTip = "ModifierTip" + tipNum;
            tags.func_74778_a(modTip, modifierTip);
            return tipNum;
        } while (!(tag = tags.func_74779_i(tip)).contains(tooltip));
        tags.func_74778_a(tip, this.getProperName(tooltip, tag));
        String modTip = "ModifierTip" + tipNum;
        tag = tags.func_74779_i(modTip);
        tags.func_74778_a(modTip, this.getProperName(modifierTip, tag));
        return tipNum;
    }

    protected String getProperName(String tooltip, String tag) {
        if (tag.isEmpty()) {
            return tooltip + " I";
        }
        if (tag.equals(tooltip) || tag.equals(tooltip + " I")) {
            return tooltip + " II";
        }
        if (tag.equals(tooltip + " II")) {
            return tooltip + " III";
        }
        if (tag.equals(tooltip + " III")) {
            return tooltip + " IV";
        }
        if (tag.equals(tooltip + " IV")) {
            return tooltip + " V";
        }
        if (tag.equals(tooltip + " V")) {
            return tooltip + " VI";
        }
        if (tag.equals(tooltip + " VI")) {
            return tooltip + " VII";
        }
        if (tag.equals(tooltip + " VII")) {
            return tooltip + " VIII";
        }
        if (tag.equals(tooltip + " VIII")) {
            return tooltip + " IX";
        }
        if (tag.equals(tooltip + " IX")) {
            return tooltip + " X";
        }
        return tooltip + " X+";
    }

    public boolean validType(IModifyable input) {
        return input.getModifyType().equals("Tool");
    }

    public boolean areItemsEquivalent(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public boolean areItemStacksEquivalent(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77960_j() != stack2.func_77960_j()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static NBTTagCompound getAttributeTag(String attributeType, String modifierName, double amount, boolean flat, UUID uuid) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("AttributeName", attributeType);
        tag.func_74778_a("Name", modifierName);
        tag.func_74780_a("Amount", amount);
        tag.func_74768_a("Operation", flat ? 0 : 1);
        tag.func_74772_a("UUIDMost", uuid.getMostSignificantBits());
        tag.func_74772_a("UUIDLeast", uuid.getLeastSignificantBits());
        return tag;
    }
}

