/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public abstract class OutputBitStream {
    private int buffer;
    private int bitCount;
    private int byteCount;

    protected abstract void writeByte(int var1) throws IOException;

    public void writeBit(boolean bit) throws IOException {
        if (this.bitCount >= 8) {
            this.flushBuffer();
        }
        this.buffer <<= 1;
        if (bit) {
            this.buffer |= 1;
        }
        ++this.bitCount;
    }

    public void flush() throws IOException {
        if (this.bitCount > 0) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this.buffer <<= 8 - this.bitCount;
        this.writeByte(this.buffer);
        ++this.byteCount;
        this.bitCount = 0;
        this.buffer = 0;
    }

    public int bytesWritten() {
        return this.byteCount;
    }

    public static OutputBitStream create(final DataOutput output) {
        return new OutputBitStream(){

            @Override
            protected void writeByte(int b) throws IOException {
                output.write(b);
            }
        };
    }

    public static OutputBitStream create(final OutputStream output) {
        return new OutputBitStream(){

            @Override
            protected void writeByte(int b) throws IOException {
                output.write(b);
            }
        };
    }
}

