/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;
import openmods.utils.ByteUtils;

public class SyncableVarInt
extends SyncableObjectBase
implements ISyncableValueProvider<Integer> {
    private int value = 0;

    public SyncableVarInt(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"Value must be non-negative");
        this.value = value;
    }

    public SyncableVarInt() {
    }

    public void modify(int by) {
        if (this.value + by >= 0) {
            this.set(this.value + by);
        }
    }

    public void set(int val) {
        Preconditions.checkArgument((val >= 0 ? 1 : 0) != 0, (Object)"Value must be non-negative");
        if (val != this.value) {
            this.value = val;
            this.markDirty();
        }
    }

    public int get() {
        return this.value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void readFromStream(DataInputStream stream) {
        this.value = ByteUtils.readVLI(stream);
    }

    @Override
    public void writeToStream(DataOutputStream stream) {
        ByteUtils.writeVLI(stream, this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74768_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        if (tag.func_74764_b(name)) {
            this.value = tag.func_74762_e(name);
        }
    }
}

