/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import openmods.calc.Frame;
import openmods.calc.IExecutable;
import openmods.calc.NoopExecutable;

public class ExecutableList<E>
implements IExecutable<E> {
    private final List<IExecutable<E>> commands;

    public ExecutableList(List<IExecutable<E>> commands) {
        this.commands = ImmutableList.copyOf(commands);
    }

    public ExecutableList(IExecutable<E> ... commands) {
        this.commands = ImmutableList.copyOf((Object[])commands);
    }

    public List<IExecutable<E>> getCommands() {
        return this.commands;
    }

    @Override
    public void execute(Frame<E> frame) {
        for (IExecutable<E> e : this.commands) {
            e.execute(frame);
        }
    }

    public String toString() {
        return "{" + Joiner.on((char)' ').join(this.commands) + "}";
    }

    public int hashCode() {
        return 31 + this.commands.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ExecutableList && ((ExecutableList)obj).commands.equals(this.commands);
    }

    public void deepFlatten(List<IExecutable<E>> output) {
        for (IExecutable<E> e : this.commands) {
            if (e instanceof ExecutableList) {
                ((ExecutableList)e).deepFlatten(output);
                continue;
            }
            output.add(e);
        }
    }

    public static <E> IExecutable<E> wrap(List<IExecutable<E>> exprs) {
        if (exprs.size() == 0) {
            return new NoopExecutable();
        }
        if (exprs.size() == 1) {
            return exprs.get(0);
        }
        return new ExecutableList<E>(exprs);
    }
}

