/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.tracker;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import remoteio.common.lib.DimensionalCoords;
import remoteio.common.tile.TileRemoteInterface;

public class RedstoneTracker {
    private static BiMap<DimensionalCoords, DimensionalCoords> positionBiMap = HashBiMap.create();

    public static void register(TileRemoteInterface tileRemoteInterface) {
        if (tileRemoteInterface.remotePosition != null && tileRemoteInterface.hasTransferChip(21)) {
            positionBiMap.put((Object)tileRemoteInterface.remotePosition, (Object)DimensionalCoords.create(tileRemoteInterface));
            tileRemoteInterface.remotePosition.markForUpdate();
        }
    }

    public static void unregister(TileRemoteInterface tileRemoteInterface) {
        DimensionalCoords remote = (DimensionalCoords)positionBiMap.inverse().get((Object)DimensionalCoords.create(tileRemoteInterface));
        if (remote != null) {
            positionBiMap.remove((Object)remote);
            remote.markForUpdate();
        }
    }

    public static int getIndirectPowerLevelTo(World world, int x, int y, int z, int side) {
        int local;
        ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)side).getOpposite();
        int fx = x + forgeDirection.offsetX;
        int fy = y + forgeDirection.offsetY;
        int fz = z + forgeDirection.offsetZ;
        DimensionalCoords dimensionalCoords = new DimensionalCoords(world, fx, fy, fz);
        DimensionalCoords tileCoords = (DimensionalCoords)positionBiMap.get((Object)dimensionalCoords);
        int level = 0;
        if (tileCoords != null) {
            level = RedstoneTracker.default_getIndirectPowerLevelTo(tileCoords.getWorld(), tileCoords.x + forgeDirection.getOpposite().offsetX, tileCoords.y + forgeDirection.getOpposite().offsetY, tileCoords.z + forgeDirection.getOpposite().offsetZ, side);
        }
        if ((local = RedstoneTracker.default_getIndirectPowerLevelTo(world, x, y, z, side)) > level) {
            level = local;
        }
        return level;
    }

    private static int default_getIndirectPowerLevelTo(World world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        return block.shouldCheckWeakPower((IBlockAccess)world, x, y, z, side) ? world.func_94577_B(x, y, z) : block.func_149709_b((IBlockAccess)world, x, y, z, side);
    }
}

