/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TabContainer;
import javax.annotation.Nullable;

public class TabButton
extends Widget
implements Interactable {
    private final int page;
    private TabContainer tabController;
    private IDrawable[] activeBackground;

    public TabButton(int page) {
        this.page = page;
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        if (this.page != this.tabController.getCurrentPage()) {
            this.tabController.setActivePage(this.page);
        }
        return Interactable.ClickResult.ACCEPT;
    }

    protected void setTabController(TabContainer tabController) {
        this.tabController = tabController;
    }

    public int getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public IDrawable[] getBackground() {
        if (this.isSelected() && this.activeBackground != null) {
            return this.activeBackground;
        }
        return super.getBackground();
    }

    public boolean isSelected() {
        return this.page == this.tabController.getCurrentPage();
    }

    public TabButton setBackground(boolean active, IDrawable ... drawables) {
        if (active) {
            this.activeBackground = drawables;
        } else {
            this.setBackground(drawables);
        }
        return this;
    }
}

