/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui.misc;

import net.minecraft.client.resources.I18n;
import serverutils.lib.gui.CheckBoxList;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.PanelScrollBar;
import serverutils.lib.gui.TextBox;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.Widget;
import serverutils.lib.gui.WidgetLayout;

public abstract class GuiButtonListBase
extends GuiBase {
    protected final Panel panelButtons = this.createButtonPanel();
    protected final PanelScrollBar scrollBar = new PanelScrollBar(this, this.panelButtons);
    private String title = "";
    private TextBox searchBox;
    private boolean hasSearchBox;
    private int borderH;
    private int borderV;
    private int borderW;

    public GuiButtonListBase() {
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setScrollStep(20);
        this.searchBox = new TextBox(this){

            @Override
            public void onTextChanged() {
                GuiButtonListBase.this.panelButtons.refreshWidgets();
            }
        };
        this.searchBox.ghostText = I18n.func_135052_a((String)"gui.search_box", (Object[])new Object[0]);
        this.hasSearchBox = false;
    }

    public void setHasSearchBox(boolean v) {
        if (this.hasSearchBox != v) {
            this.hasSearchBox = v;
            this.refreshWidgets();
        }
    }

    public String getFilterText(Widget widget) {
        return widget.getTitle().toLowerCase();
    }

    @Override
    public void addWidgets() {
        this.add(this.panelButtons);
        this.add(this.scrollBar);
        if (this.hasSearchBox) {
            this.add(this.searchBox);
        }
    }

    protected Panel createButtonPanel() {
        return (Panel)new Panel(this){

            @Override
            public void add(Widget widget) {
                if (!GuiButtonListBase.this.hasSearchBox || GuiButtonListBase.this.searchBox.getText().isEmpty() || GuiButtonListBase.this.getFilterText(widget).contains(GuiButtonListBase.this.searchBox.getText().toLowerCase()) || widget instanceof CheckBoxList) {
                    super.add(widget);
                }
            }

            @Override
            public void addWidgets() {
                GuiButtonListBase.this.addButtons(this);
            }

            @Override
            public void alignWidgets() {
                this.setY(GuiButtonListBase.this.hasSearchBox ? 23 : 9);
                int prevWidth = this.width;
                if (this.widgets.isEmpty()) {
                    this.setWidth(100);
                } else {
                    this.setWidth(100);
                    for (Widget w : this.widgets) {
                        this.setWidth(Math.max(this.width, w.width));
                    }
                }
                if (GuiButtonListBase.this.hasSearchBox) {
                    this.setWidth(Math.max(this.width, prevWidth));
                }
                for (Widget w : this.widgets) {
                    w.setX(GuiButtonListBase.this.borderH);
                    w.setWidth(this.width - GuiButtonListBase.this.borderH * 2);
                }
                this.setHeight(140);
                GuiButtonListBase.this.scrollBar.setPosAndSize(this.posX + this.width + 6, this.posY - 1, 16, this.height + 2);
                GuiButtonListBase.this.scrollBar.setMaxValue(this.align(new WidgetLayout.Vertical(GuiButtonListBase.this.borderV, GuiButtonListBase.this.borderW, GuiButtonListBase.this.borderV)));
                this.getGui().setWidth(GuiButtonListBase.this.scrollBar.posX + GuiButtonListBase.this.scrollBar.width + 8);
                this.getGui().setHeight(this.height + 18 + (GuiButtonListBase.this.hasSearchBox ? 14 : 0));
                if (GuiButtonListBase.this.hasSearchBox) {
                    GuiButtonListBase.this.searchBox.setPosAndSize(8, 6, this.getGui().width - 16, 12);
                }
            }

            @Override
            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                theme.drawPanelBackground(x, y, w, h);
            }
        }.setPosAndSize(9, 9, 0, 146);
    }

    @Override
    public void alignWidgets() {
        this.panelButtons.alignWidgets();
    }

    public abstract void addButtons(Panel var1);

    public void setTitle(String txt) {
        this.title = txt;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setBorder(int h, int v, int w) {
        this.borderH = h;
        this.borderV = v;
        this.borderW = w;
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        super.drawBackground(theme, x, y, w, h);
        String title = this.getTitle();
        if (!title.isEmpty()) {
            theme.drawString(title, x + (this.width - theme.getStringWidth(title)) / 2, y - theme.getFontHeight() - 2, 2);
        }
    }

    public boolean hasSearchBox() {
        return this.hasSearchBox;
    }

    public String getTextInSearchBox() {
        return this.searchBox.getText().toLowerCase();
    }

    public void focus() {
        this.searchBox.setFocused(true);
    }
}

