/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.MutableColor4I;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;

public class ConfigColor
extends ConfigValue {
    public static final String ID = "color";
    private final MutableColor4I value = Color4I.WHITE.mutable();

    public ConfigColor(Color4I v) {
        this.value.set(v, 255);
    }

    public ConfigColor(int col) {
        this.value.set(0xFF000000 | col);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public MutableColor4I getColor() {
        return this.value;
    }

    @Override
    public String getString() {
        return this.getColor().toString();
    }

    @Override
    public boolean getBoolean() {
        return !this.getColor().isEmpty();
    }

    @Override
    public int getInt() {
        return this.getColor().rgba();
    }

    @Override
    public ConfigColor copy() {
        return new ConfigColor(this.getColor());
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        block10: {
            try {
                if (string.indexOf(44) != -1) {
                    if (string.length() < 5) {
                        return false;
                    }
                    String[] s = string.split(",");
                    if (s.length == 3 || s.length == 4) {
                        int[] c = new int[4];
                        c[3] = 255;
                        for (int i = 0; i < s.length; ++i) {
                            c[i] = Integer.parseInt(s[i]);
                        }
                        if (!simulate) {
                            this.getColor().set(c[0], c[1], c[2], c[3]);
                        }
                        return true;
                    }
                    break block10;
                }
                if (string.length() < 6) {
                    return false;
                }
                if (string.startsWith("#")) {
                    string = string.substring(1);
                }
                int hex = Integer.parseInt(string, 16);
                if (!simulate) {
                    this.getColor().set(0xFF000000 | hex);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        nbt.func_74768_a(key, this.getInt());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.getColor().set(0xFF000000 | nbt.func_74762_e(key));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeInt(this.getInt());
    }

    @Override
    public void readData(DataIn data) {
        this.getColor().set(data.readInt());
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        this.getColor().set(value.getColor());
    }
}

