/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.shims;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.shims.IPlayerShim;
import vazkii.botania.api.item.IBlockProvider;

public class BasicPlayerShim
implements IPlayerShim {
    private EntityPlayer player;
    private boolean providersEnabled;

    public BasicPlayerShim(EntityPlayer player) {
        this.player = player;
        this.providersEnabled = BasicPlayerShim.areProvidersEnabled();
    }

    private static Block getBlock(ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b());
    }

    private static int getBlockMeta(ItemStack stack) {
        return stack.func_77981_g() ? stack.func_77960_j() : 0;
    }

    private static boolean areProvidersEnabled() {
        try {
            boolean disable = new Object() instanceof IBlockProvider;
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public double getReach() {
        if (this.player instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)this.player).field_71134_c.getBlockReachDistance();
        }
        return 5.0;
    }

    @Override
    public int countItems(ItemStack itemStack, boolean isNBTSensitive) {
        int total = 0;
        if (itemStack == null || this.player.field_71071_by == null || this.player.field_71071_by.field_70462_a == null) {
            return 0;
        }
        Block block = BasicPlayerShim.getBlock(itemStack);
        int meta = BasicPlayerShim.getBlockMeta(itemStack);
        for (ItemStack inventoryStack : this.player.field_71071_by.field_70462_a) {
            if (inventoryStack != null && itemStack.func_77969_a(inventoryStack) && (!isNBTSensitive || ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)inventoryStack))) {
                total += Math.max(0, inventoryStack.field_77994_a);
                continue;
            }
            if (!this.providersEnabled || inventoryStack == null || !(inventoryStack.func_77973_b() instanceof IBlockProvider)) continue;
            IBlockProvider prov = (IBlockProvider)inventoryStack.func_77973_b();
            int provCount = prov.getBlockCount(this.player, itemStack, inventoryStack, block, meta);
            if (provCount == -1) {
                return Integer.MAX_VALUE;
            }
            total += provCount;
        }
        return itemStack.field_77994_a > 0 ? total / itemStack.field_77994_a : 0;
    }

    @Override
    public boolean useItem(ItemStack itemStack, boolean isNBTSensitive) {
        if (itemStack == null || this.player.field_71071_by == null || this.player.field_71071_by.field_70462_a == null) {
            return false;
        }
        int toUse = itemStack.field_77994_a;
        ArrayList<ItemStack> providers = new ArrayList<ItemStack>();
        for (int i = this.player.field_71071_by.field_70462_a.length - 1; i >= 0; --i) {
            ItemStack inventoryStack = this.player.field_71071_by.field_70462_a[i];
            if (inventoryStack != null && itemStack.func_77969_a(inventoryStack) && (!isNBTSensitive || ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)inventoryStack))) {
                if (inventoryStack.field_77994_a < toUse) {
                    inventoryStack.field_77994_a = 0;
                    toUse -= inventoryStack.field_77994_a;
                } else {
                    inventoryStack.field_77994_a -= toUse;
                    toUse = 0;
                }
                if (inventoryStack.field_77994_a == 0) {
                    this.player.field_71071_by.func_70299_a(i, null);
                }
                this.player.field_71069_bz.func_75142_b();
                if (toUse > 0) continue;
                return true;
            }
            if (!this.providersEnabled || inventoryStack == null || !(inventoryStack.func_77973_b() instanceof IBlockProvider)) continue;
            providers.add(inventoryStack);
        }
        if (toUse == 1) {
            Block block = BasicPlayerShim.getBlock(itemStack);
            int meta = BasicPlayerShim.getBlockMeta(itemStack);
            for (ItemStack provStack : providers) {
                IBlockProvider prov = (IBlockProvider)provStack.func_77973_b();
                if (!prov.provideBlock(this.player, itemStack, provStack, block, meta, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getNextItem(Block block, int meta) {
        for (int i = this.player.field_71071_by.field_70462_a.length - 1; i >= 0; --i) {
            ItemStack itemStack = this.player.field_71071_by.field_70462_a[i];
        }
        return null;
    }

    @Override
    public Point3d getPlayerPosition() {
        return new Point3d((int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v);
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public boolean isCreative() {
        return this.player.field_71075_bZ.field_75098_d;
    }
}

