/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.compat.forestrymc;

import forestry.arboriculture.blocks.BlockRegistryArboriculture;
import forestry.arboriculture.tiles.TileWood;
import forestry.plugins.PluginArboriculture;
import forestry.plugins.PluginManager;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.core.conversion.CustomMapping;
import portablejim.bbw.shims.IWorldShim;

public class ForestryMCCustomMapping
extends CustomMapping {
    public ForestryMCCustomMapping(Block lookBlock, int meta) {
        super(lookBlock, meta, new ItemStack(Item.func_150898_a((Block)lookBlock)), lookBlock, meta, true);
    }

    @Override
    public ItemStack getItems(IWorldShim world, Point3d point) {
        TileEntity tileEntity = world.getTile(point);
        if (tileEntity instanceof TileWood) {
            return TileWood.getPickBlock((Block)this.getLookBlock(), (IBlockAccess)world.getWorld(), (int)point.x, (int)point.y, (int)point.z);
        }
        return super.getItems(world, point);
    }

    public static void register() {
        if (PluginManager.Module.ARBORICULTURE.isEnabled()) {
            BlockRegistryArboriculture blocks = PluginArboriculture.blocks;
            ForestryMCCustomMapping.registerMappings((Block)blocks.logs, 0, 4, 8);
            ForestryMCCustomMapping.registerMappings((Block)blocks.logsFireproof, 0, 4, 8);
            ForestryMCCustomMapping.registerMappings((Block)blocks.planks, 0);
            ForestryMCCustomMapping.registerMappings((Block)blocks.planksFireproof, 0);
            ForestryMCCustomMapping.registerMappings((Block)blocks.slabs, 0, 8);
            ForestryMCCustomMapping.registerMappings((Block)blocks.slabsFireproof, 0, 8);
            ForestryMCCustomMapping.registerMappings((Block)blocks.slabsDouble, 0);
            ForestryMCCustomMapping.registerMappings((Block)blocks.slabsDoubleFireproof, 0);
            ForestryMCCustomMapping.registerMappings((Block)blocks.stairs, ForestryMCCustomMapping.range(7));
            ForestryMCCustomMapping.registerMappings((Block)blocks.stairsFireproof, ForestryMCCustomMapping.range(7));
            ForestryMCCustomMapping.registerMappings((Block)blocks.fences, 0);
            ForestryMCCustomMapping.registerMappings((Block)blocks.fencesFireproof, 0);
        }
    }

    private static void registerMappings(Block block, int ... metas) {
        for (int meta : metas) {
            BetterBuildersWandsMod.instance.mappingManager.setMapping(new ForestryMCCustomMapping(block, meta));
        }
    }

    private static int[] range(int max) {
        int[] range = new int[max + 1];
        for (int i = 0; i <= max; ++i) {
            range[i] = i;
        }
        return range;
    }
}

