/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.api.content.BOPCItems;
import biomesoplenty.client.render.RenderUtils;
import biomesoplenty.common.blocks.templates.BOPBlockWorldDecor;
import biomesoplenty.common.configuration.BOPConfigurationMisc;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBOPFoliage
extends BOPBlockWorldDecor
implements IShearable {
    private static final String[] foliageTypes = new String[]{"duckweed", "shortgrass", "mediumgrass", "flaxbottom", "bush", "sprout", "flaxtop", "poisonivy", "berrybush", "shrub", "wheatgrass", "dampgrass", "koru", "cloverpatch", "leafpile", "deadleafpile"};
    private IIcon[] textures;
    public IIcon flaxFlowers;
    public IIcon shrubBranch;
    public IIcon berryBushBerry;
    private static final int FLAXTOP = 6;
    private static final int FLAXBOTTOM = 3;
    public static ItemStack turnipSeedStack = new ItemStack(BOPCItems.turnipSeeds, 1);

    public BlockBOPFoliage() {
        super(Material.field_151585_k);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149647_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[foliageTypes.length];
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = iconRegister.func_94245_a("biomesoplenty:" + foliageTypes[i]);
        }
        this.flaxFlowers = iconRegister.func_94245_a("biomesoplenty:flax_flowers");
        this.shrubBranch = iconRegister.func_94245_a("biomesoplenty:shrub_branch");
        this.berryBushBerry = iconRegister.func_94245_a("biomesoplenty:berrybush_berry");
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta >= this.textures.length) {
            meta = 0;
        }
        return this.textures[meta];
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < foliageTypes.length; ++i) {
            if (i == 6) continue;
            list.add(new ItemStack(block, 1, i));
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        switch (meta) {
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                if (world.field_73012_v.nextInt(8) != 0) {
                    return ret;
                }
                ItemStack item = ForgeHooks.getGrassSeed((World)world);
                if (item == null) break;
                ret.add(item);
                break;
            }
            case 5: {
                if (world.field_73012_v.nextInt(50) != 0) {
                    return ret;
                }
                if (world.field_73012_v.nextInt(2) == 0) {
                    ret.add(new ItemStack(Items.field_151172_bF, 1));
                    break;
                }
                ret.add(new ItemStack(Items.field_151174_bG, 1));
                break;
            }
            case 12: {
                if (world.field_73012_v.nextInt(32) != 0) {
                    return ret;
                }
                if (world.field_73012_v.nextInt(2) != 0) break;
                ret.add(turnipSeedStack.func_77946_l());
                break;
            }
            case 8: {
                ret.add(new ItemStack(BOPCItems.food, 1, 0));
            }
        }
        return ret;
    }

    @Override
    public boolean isValidPosition(World world, int x, int y, int z, int metadata) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (block == Blocks.field_150350_a && world.field_73011_w.field_76574_g != -1 && (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z))) {
            return false;
        }
        switch (metadata) {
            case 6: {
                return block == this;
            }
            case 0: {
                return block == Blocks.field_150355_j;
            }
            case 14: {
                return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == BOPCBlocks.longGrass || block == BOPCBlocks.overgrownNetherrack || block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
            }
            case 15: {
                return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == BOPCBlocks.longGrass || block == BOPCBlocks.overgrownNetherrack || block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
            }
        }
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == BOPCBlocks.longGrass || block == BOPCBlocks.overgrownNetherrack || block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        super.func_149734_b(world, x, y, z, random);
        int meta = world.func_72805_g(x, y, z);
        int i = 5149489;
        double d0 = (double)(i >> 16 & 0xFF) / 255.0;
        double d1 = (double)(i >> 8 & 0xFF) / 255.0;
        double d2 = (double)(i >> 0 & 0xFF) / 255.0;
        if (meta == 7 && random.nextInt(32) == 0) {
            world.func_72869_a("mobSpell", (double)((float)x + random.nextFloat()), (double)((float)y + random.nextFloat()), (double)((float)z + random.nextFloat()), d0, d1, d2);
        }
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        super.func_149695_a(world, x, y, z, neighborBlock);
        int metadata = world.func_72805_g(x, y, z);
        if (world.func_72805_g(x, y, z) == 3) {
            if (world.func_147439_a(x, y + 1, z) != this) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
            } else if (!this.isValidPosition(world, x, y, z, metadata)) {
                this.func_149697_b(world, x, y + 1, z, world.func_72805_g(x, y + 1, z), 0);
                world.func_147468_f(x, y + 1, z);
            }
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        int meta = world.func_72805_g(x, y, z);
        if (!world.field_72995_K && meta == 7 && entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPlayer) {
                InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
                if ((inventory.field_70460_b[0] == null || inventory.field_70460_b[1] == null) && BOPConfigurationMisc.poisonIvyEffects) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100));
                }
            } else {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 100));
            }
        }
    }

    public int func_149635_D() {
        double var1 = 0.5;
        double var3 = 1.0;
        return ColorizerGrass.func_77480_a((double)var1, (double)var3);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int par1) {
        return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
    }

    public int func_149645_b() {
        return RenderUtils.foliageModel;
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 9 || world.func_72805_g(x, y, z) == 14) {
            return world.func_72807_a(x, z).func_150571_c(x, y, z);
        }
        if (world.func_72805_g(x, y, z) == 15) {
            return 0xFFFFFF;
        }
        return world.func_72807_a(x, z).func_150558_b(x, y, z);
    }

    public int func_149643_k(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 6) {
            meta = 3;
        }
        return meta;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return null;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
                break;
            }
            case 1: {
                this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.25f, 0.9f);
                break;
            }
            case 2: {
                this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.6f, 0.9f);
                break;
            }
            case 13: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
                break;
            }
            case 14: 
            case 15: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
                break;
            }
            default: {
                this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.8f, 0.9f);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitVecX, float hitVecY, float hitVecZ) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 8) {
            world.func_147465_d(x, y, z, (Block)this, 4, 3);
            EntityItem entityitem = new EntityItem(world, (double)x, (double)y, (double)z, new ItemStack(BOPCItems.food, 1, 0));
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityitem);
                if (!(player instanceof FakePlayer)) {
                    entityitem.func_70100_b_(player);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (world.func_72805_g(x, y, z) == 6) {
            ret.add(new ItemStack(BOPCBlocks.foliage, 1, 3));
        } else if (world.func_72805_g(x, y, z) == 8) {
            ret.add(new ItemStack(BOPCBlocks.foliage, 1, 4));
        } else {
            ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z)));
        }
        return ret;
    }
}

