/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.mob.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.entity.IAntiGrav;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.monster.IMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class EntityFlyingMob
extends EntityFlying
implements IMob,
IAntiGrav {
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    private Entity targetedEntity;
    private int aggroCooldown;
    public int prevAttackCounter;
    public int attackCounter;
    protected int explosionStrength = 1;
    protected static final float distanceToKeep = 10.0f;

    public EntityFlyingMob(World world) {
        super(world);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean useShootingTexture() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    protected abstract float getVisionDistance();

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    protected abstract void performAttack(Entity var1, double var2, double var4, double var6);

    protected void findWaypoint() {
        if (this.targetedEntity != null) {
            Vector3 targetVec = new Vector3(this.targetedEntity);
            Vector3 myPos = new Vector3((Entity)this);
            Vector3 thisToTarget = myPos.difference(targetVec);
            double distance = thisToTarget.getMagnitude();
            thisToTarget.scale(10.0 / distance);
            myPos = targetVec.translate(thisToTarget);
            if (this.isCourseTraversable(myPos.x, myPos.y, myPos.z, distance)) {
                this.waypointX = myPos.x;
                this.waypointY = myPos.y;
                this.waypointZ = myPos.z;
                return;
            }
        }
        this.waypointX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
        this.waypointY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
        this.waypointZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
    }

    protected void func_70626_be() {
        byte b0;
        byte b1;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.func_70623_bb();
        this.prevAttackCounter = this.attackCounter;
        double deltaX = this.waypointX - this.field_70165_t;
        double deltaY = this.waypointY - this.field_70163_u;
        double deltaZ = this.waypointZ - this.field_70161_v;
        double distanceSq = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        if (this.targetedEntity != null && this.targetedEntity.field_70128_L) {
            this.targetedEntity = null;
        }
        if (distanceSq < 1.0 || distanceSq > 3600.0) {
            this.findWaypoint();
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, distanceSq = (double)MathHelper.func_76133_a((double)distanceSq))) {
                this.field_70159_w += deltaX / distanceSq * 0.1;
                this.field_70181_x += deltaY / distanceSq * 0.1;
                this.field_70179_y += deltaZ / distanceSq * 0.1;
            } else {
                this.waypointX = this.field_70165_t;
                this.waypointY = this.field_70163_u;
                this.waypointZ = this.field_70161_v;
            }
        }
        if (this.targetedEntity == null || this.aggroCooldown-- <= 0) {
            this.targetedEntity = this.field_70170_p.func_72856_b((Entity)this, (double)this.getVisionDistance());
            if (this.targetedEntity != null) {
                this.aggroCooldown = 20;
            }
        }
        double maxTargetDistance = 64.0;
        if (this.targetedEntity != null && this.targetedEntity.func_70068_e((Entity)this) < 4096.0) {
            this.func_70625_a(this.targetedEntity, 10.0f, this.func_70646_bf());
            double accelX = this.targetedEntity.field_70165_t - this.field_70165_t;
            double accelY = this.targetedEntity.field_70121_D.field_72338_b + (double)(this.targetedEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double accelZ = this.targetedEntity.field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(accelX, accelZ)) * 180.0f / (float)Math.PI;
            if (this.func_70685_l(this.targetedEntity)) {
                if (this.attackCounter == 10) {
                    // empty if block
                }
                ++this.attackCounter;
                if (this.attackCounter == 20) {
                    this.field_70170_p.func_72956_a((Entity)this, this.getFiringSound(), this.func_70599_aP(), 1.0f);
                    this.performAttack(this.targetedEntity, accelX, accelY, accelZ);
                    this.attackCounter = -40;
                }
            } else if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        } else {
            this.field_70125_A = this.field_70698_bv;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        }
        if (!this.field_70170_p.field_72995_K && (b1 = this.field_70180_af.func_75683_a(16)) != (b0 = (byte)(this.attackCounter > 10 ? 1 : 0))) {
            this.field_70180_af.func_75692_b(16, (Object)b0);
        }
    }

    protected boolean isCourseTraversable(double p_70790_1_, double p_70790_3_, double p_70790_5_, double distance) {
        double relDeltaX = (this.waypointX - this.field_70165_t) / distance;
        double relDeltaY = (this.waypointY - this.field_70163_u) / distance;
        double relDeltaZ = (this.waypointZ - this.field_70161_v) / distance;
        AxisAlignedBB axisalignedbb = this.field_70121_D.func_72329_c();
        int i = 1;
        while ((double)i < distance) {
            axisalignedbb.func_72317_d(relDeltaX, relDeltaY, relDeltaZ);
            if (!this.field_70170_p.func_72945_a((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(20) == 0 && super.func_70601_bi() && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    public abstract String getFiringSound();

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("ExplosionPower", this.explosionStrength);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        if (tagCompund.func_150297_b("ExplosionPower", 99)) {
            this.explosionStrength = tagCompund.func_74762_e("ExplosionPower");
        }
    }
}

