/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import gcewing.projectblue.BaseNBTChannel;
import gcewing.projectblue.ControlPanelPart;
import gcewing.projectblue.ProjectBlue;
import gcewing.projectblue.ProjectBlueClient;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ProjectBlueChannel
extends BaseNBTChannel<Message> {
    public ProjectBlueChannel(String name) {
        super(name);
    }

    @Override
    Class<Message> getPacketType() {
        return Message.class;
    }

    @Override
    void onReceiveFromClient(Message type, NBTTagCompound nbt, EntityPlayer player) {
        switch (type) {
            case UPDATE_CONTROL_PANEL_TEXT: {
                this.onReceiveUpdateControlpanelText(nbt, player);
            }
        }
    }

    @Override
    void onReceiveFromServer(Message type, NBTTagCompound nbt) {
        ((ProjectBlueClient)ProjectBlue.mod.client).onReceiveFromServer(type, nbt);
    }

    public void sendEditControlPanelText(EntityPlayer player, ControlPanelPart part, int cell) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.setPart(nbt, part);
        nbt.func_74768_a("cell", cell);
        System.out.printf("ProjectBlueChannel.sendEditControlPanelText: to %s\n", player);
        this.sendToPlayer(Message.EDIT_CONTROL_PANEL_TEXT, nbt, player);
    }

    public void sendUpdateControlPanelText(ControlPanelPart part, int cell, int line, String text) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.setPart(nbt, part);
        nbt.func_74768_a("cell", cell);
        nbt.func_74768_a("line", line);
        nbt.func_74778_a("text", text);
        this.sendToServer(Message.UPDATE_CONTROL_PANEL_TEXT, nbt);
    }

    void onReceiveUpdateControlpanelText(NBTTagCompound nbt, EntityPlayer player) {
        TMultiPart part = this.getServerPart(nbt, player);
        if (part instanceof ControlPanelPart) {
            int cell = nbt.func_74762_e("cell");
            int line = nbt.func_74762_e("line");
            String text = nbt.func_74779_i("text");
            ((ControlPanelPart)part).setLabel(cell, line, text);
        }
    }

    void setPart(NBTTagCompound nbt, TMultiPart part) {
        nbt.func_74768_a("blockX", part.x());
        nbt.func_74768_a("blockY", part.y());
        nbt.func_74768_a("blockZ", part.z());
        nbt.func_74768_a("partIndex", part.tile().jPartList().indexOf(part));
    }

    TMultiPart getServerPart(NBTTagCompound nbt, EntityPlayer player) {
        return ProjectBlueChannel.getPart(nbt, player.func_130014_f_());
    }

    public static TMultiPart getPart(NBTTagCompound nbt, World world) {
        int z;
        int y;
        int x = nbt.func_74762_e("blockX");
        TileEntity te = world.func_147438_o(x, y = nbt.func_74762_e("blockY"), z = nbt.func_74762_e("blockZ"));
        if (te instanceof TileMultipart) {
            TileMultipart tmp = (TileMultipart)te;
            List parts = tmp.jPartList();
            int i = nbt.func_74762_e("partIndex");
            if (i >= 0 && i < parts.size()) {
                return (TMultiPart)parts.get(i);
            }
        }
        return null;
    }

    static enum Message {
        EDIT_CONTROL_PANEL_TEXT,
        UPDATE_CONTROL_PANEL_TEXT;

    }
}

