/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.model.steps;

import com.gtnewhorizons.navigator.api.journeymap.drawsteps.JMRenderStep;
import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.util.DrawUtils;
import com.gtnewhorizons.navigator.api.xaero.rendersteps.XaeroRenderStep;
import cpw.mods.fml.common.Optional;
import javax.annotation.Nullable;
import journeymap.client.render.map.GridRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import org.joml.Vector2d;
import org.lwjgl.opengl.GL11;

@Optional.Interface(iface="com.gtnewhorizons.navigator.api.journeymap.drawsteps.JMRenderStep", modid="journeymap")
public abstract class UniversalRenderStep<T extends ILocationProvider>
implements JMRenderStep,
XaeroRenderStep {
    private final Vector2d pos = new Vector2d();
    protected double fontScale = 1.0;
    protected double rotation = 0.0;
    protected double width = 16.0;
    protected double height = 16.0;
    protected double x;
    protected double y;
    protected double blockSize = 1.0;
    protected T location;
    protected double offsetX;
    protected double offsetY;
    protected double zoom;
    protected boolean isJourneyMap;
    protected boolean isXaero;
    protected double minScale;
    protected boolean shouldScale;

    public UniversalRenderStep(T location) {
        this.location = location;
    }

    public abstract void draw(double var1, double var3, float var5, double var6);

    public void preRender(double x, double y, float drawScale, double zoom) {
    }

    @Override
    public final void draw(@Nullable GuiScreen gui, double cameraX, double cameraZ, double scale) {
    }

    @Override
    public final void draw(double cameraX, double cameraZ, double scale, float guiBasedScale) {
        this.isXaero = true;
        this.x = this.location.getBlockX() - 0.5 - cameraX;
        this.y = this.location.getBlockZ() - 0.5 - cameraZ;
        this.zoom = scale;
        this.preRender(this.getX(), this.getY(), guiBasedScale, scale);
        GL11.glPushMatrix();
        if (this.shouldScale) {
            double scaling = this.getScaling(scale);
            this.x *= scaling;
            this.y *= scaling;
            GL11.glScaled((double)(1.0 / scaling), (double)(1.0 / scaling), (double)1.0);
        }
        DrawUtils.setupDrawing();
        this.draw(this.getX(), this.getY(), guiBasedScale, scale);
        GL11.glPopMatrix();
    }

    @Override
    public final void draw(double draggedPixelX, double draggedPixelY, GridRenderer gridRenderer, float drawScale, double fontScale, double rotation) {
        this.fontScale = fontScale;
        this.rotation = rotation;
        this.isJourneyMap = true;
        this.zoom = gridRenderer.getZoom();
        Vector2d blockPos = this.getBlockFromGrid(gridRenderer, draggedPixelX, draggedPixelY, this.location.getBlockX(), this.location.getBlockZ());
        this.x = blockPos.x;
        this.y = blockPos.y;
        this.preRender(this.getX(), this.getY(), drawScale, this.zoom);
        GL11.glPushMatrix();
        DrawUtils.setupDrawing();
        this.draw(this.getX(), this.getY(), drawScale, this.zoom);
        GL11.glPopMatrix();
    }

    public void setFontScale(double fontScale) {
        this.fontScale = fontScale;
    }

    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void setSize(double size) {
        this.setSize(size, size);
    }

    public void setOffset(double offsetX, double offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void setOffset(double offset) {
        this.setOffset(offset, offset);
    }

    public double getFontScale() {
        return this.fontScale;
    }

    public double getAdjustedWidth() {
        return this.width * this.blockSize;
    }

    public double getAdjustedHeight() {
        return this.height * this.blockSize;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getX() {
        return this.x + this.offsetX;
    }

    public double getY() {
        return this.y + this.offsetY;
    }

    public void setMinScale(int minScale) {
        this.minScale = minScale;
        this.shouldScale = true;
    }

    public double getScaling(double currentScale) {
        return Math.max(currentScale, this.minScale);
    }

    public boolean isMinimap() {
        return Minecraft.func_71410_x().field_71462_r == null;
    }

    public double getZoomStep() {
        return this.isXaero ? (double)this.getXaeroZoomAsSteps(this.zoom) : this.zoom;
    }

    public T getLocation() {
        return this.location;
    }

    private Vector2d getBlockFromGrid(GridRenderer gridRenderer, double pixelX, double pixelY, double x, double z) {
        this.blockSize = (int)Math.pow(2.0, gridRenderer.getZoom());
        double localBlockX = x - gridRenderer.getCenterBlockX();
        double localBlockZ = z - gridRenderer.getCenterBlockZ();
        double pixelOffsetX = (double)(gridRenderer.getWidth() / 2) + localBlockX * this.blockSize;
        double pixelOffsetZ = (double)(gridRenderer.getHeight() / 2) + localBlockZ * this.blockSize;
        return this.pos.set(pixelOffsetX + pixelX, pixelOffsetZ + pixelY);
    }

    private int getXaeroZoomAsSteps(double zoom) {
        if (zoom < 1.0) {
            return 0;
        }
        if (zoom <= 2.0) {
            return 1;
        }
        if (zoom <= 6.0) {
            return 2;
        }
        if (zoom <= 10.0) {
            return 3;
        }
        if (zoom <= 30.0) {
            return 4;
        }
        return 5;
    }
}

