/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.gamerules;

import com.gtnewhorizon.gtnhlib.gamerules.IGameRule;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.GameRules;

public class GameRuleRegistry {
    private static final Map<String, IGameRule> gameRulesMap = new HashMap<String, IGameRule>();

    public static void registerGameRule(IGameRule rule) {
        if (gameRulesMap.containsKey(rule.getName())) {
            throw new RuntimeException("Duplicate GameRule Name: " + rule.getName());
        }
        gameRulesMap.put(rule.getName(), rule);
    }

    public static void notifyGameRuleUpdate(String name, String value, GameRules gameRules) {
        IGameRule rule = gameRulesMap.get(name);
        if (rule != null) {
            rule.onValueUpdated(value, Boolean.parseBoolean(value), gameRules);
        }
    }

    public static void injectGameRules(GameRules gameRules) {
        for (IGameRule rule : gameRulesMap.values()) {
            gameRules.func_82769_a(rule.getName(), rule.defaultValue());
        }
    }
}

